/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.util.StringUtils;

public class GetRoleRequestMarshaller
implements Marshaller<Request<GetRoleRequest>, GetRoleRequest> {
    public Request<GetRoleRequest> marshall(GetRoleRequest getRoleRequest) {
        if (getRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getRoleRequest, "IAMClient");
        request.addParameter("Action", "GetRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (getRoleRequest.roleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)getRoleRequest.roleName()));
        }
        return request;
    }
}

