/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateServiceLinkedRoleRequestMarshaller
implements Marshaller<Request<CreateServiceLinkedRoleRequest>, CreateServiceLinkedRoleRequest> {
    public Request<CreateServiceLinkedRoleRequest> marshall(CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest) {
        if (createServiceLinkedRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createServiceLinkedRoleRequest, "IAMClient");
        request.addParameter("Action", "CreateServiceLinkedRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createServiceLinkedRoleRequest.awsServiceName() != null) {
            request.addParameter("AWSServiceName", StringUtils.fromString((String)createServiceLinkedRoleRequest.awsServiceName()));
        }
        if (createServiceLinkedRoleRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createServiceLinkedRoleRequest.description()));
        }
        if (createServiceLinkedRoleRequest.customSuffix() != null) {
            request.addParameter("CustomSuffix", StringUtils.fromString((String)createServiceLinkedRoleRequest.customSuffix()));
        }
        return request;
    }
}

