/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreateSAMLProviderRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateSAMLProviderRequestMarshaller
implements Marshaller<Request<CreateSAMLProviderRequest>, CreateSAMLProviderRequest> {
    public Request<CreateSAMLProviderRequest> marshall(CreateSAMLProviderRequest createSAMLProviderRequest) {
        if (createSAMLProviderRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSAMLProviderRequest, "IAMClient");
        request.addParameter("Action", "CreateSAMLProvider");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSAMLProviderRequest.samlMetadataDocument() != null) {
            request.addParameter("SAMLMetadataDocument", StringUtils.fromString((String)createSAMLProviderRequest.samlMetadataDocument()));
        }
        if (createSAMLProviderRequest.name() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createSAMLProviderRequest.name()));
        }
        return request;
    }
}

