/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreatePolicyRequestMarshaller
implements Marshaller<Request<CreatePolicyRequest>, CreatePolicyRequest> {
    public Request<CreatePolicyRequest> marshall(CreatePolicyRequest createPolicyRequest) {
        if (createPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPolicyRequest, "IAMClient");
        request.addParameter("Action", "CreatePolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString((String)createPolicyRequest.policyName()));
        }
        if (createPolicyRequest.path() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createPolicyRequest.path()));
        }
        if (createPolicyRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)createPolicyRequest.policyDocument()));
        }
        if (createPolicyRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createPolicyRequest.description()));
        }
        return request;
    }
}

