/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import software.amazon.awssdk.services.iam.model.PolicySourceType;
import software.amazon.awssdk.services.iam.model.Position;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Statement
implements ToCopyableBuilder<Builder, Statement> {
    private final String sourcePolicyId;
    private final String sourcePolicyType;
    private final Position startPosition;
    private final Position endPosition;

    private Statement(BuilderImpl builder) {
        this.sourcePolicyId = builder.sourcePolicyId;
        this.sourcePolicyType = builder.sourcePolicyType;
        this.startPosition = builder.startPosition;
        this.endPosition = builder.endPosition;
    }

    public String sourcePolicyId() {
        return this.sourcePolicyId;
    }

    public String sourcePolicyType() {
        return this.sourcePolicyType;
    }

    public Position startPosition() {
        return this.startPosition;
    }

    public Position endPosition() {
        return this.endPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourcePolicyId() == null ? 0 : this.sourcePolicyId().hashCode());
        hashCode = 31 * hashCode + (this.sourcePolicyType() == null ? 0 : this.sourcePolicyType().hashCode());
        hashCode = 31 * hashCode + (this.startPosition() == null ? 0 : this.startPosition().hashCode());
        hashCode = 31 * hashCode + (this.endPosition() == null ? 0 : this.endPosition().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Statement)) {
            return false;
        }
        Statement other = (Statement)obj;
        if (other.sourcePolicyId() == null ^ this.sourcePolicyId() == null) {
            return false;
        }
        if (other.sourcePolicyId() != null && !other.sourcePolicyId().equals(this.sourcePolicyId())) {
            return false;
        }
        if (other.sourcePolicyType() == null ^ this.sourcePolicyType() == null) {
            return false;
        }
        if (other.sourcePolicyType() != null && !other.sourcePolicyType().equals(this.sourcePolicyType())) {
            return false;
        }
        if (other.startPosition() == null ^ this.startPosition() == null) {
            return false;
        }
        if (other.startPosition() != null && !other.startPosition().equals(this.startPosition())) {
            return false;
        }
        if (other.endPosition() == null ^ this.endPosition() == null) {
            return false;
        }
        return other.endPosition() == null || other.endPosition().equals(this.endPosition());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourcePolicyId() != null) {
            sb.append("SourcePolicyId: ").append(this.sourcePolicyId()).append(",");
        }
        if (this.sourcePolicyType() != null) {
            sb.append("SourcePolicyType: ").append(this.sourcePolicyType()).append(",");
        }
        if (this.startPosition() != null) {
            sb.append("StartPosition: ").append(this.startPosition()).append(",");
        }
        if (this.endPosition() != null) {
            sb.append("EndPosition: ").append(this.endPosition()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourcePolicyId;
        private String sourcePolicyType;
        private Position startPosition;
        private Position endPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(Statement model) {
            this.setSourcePolicyId(model.sourcePolicyId);
            this.setSourcePolicyType(model.sourcePolicyType);
            this.setStartPosition(model.startPosition);
            this.setEndPosition(model.endPosition);
        }

        public final String getSourcePolicyId() {
            return this.sourcePolicyId;
        }

        @Override
        public final Builder sourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
            return this;
        }

        public final void setSourcePolicyId(String sourcePolicyId) {
            this.sourcePolicyId = sourcePolicyId;
        }

        public final String getSourcePolicyType() {
            return this.sourcePolicyType;
        }

        @Override
        public final Builder sourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
            return this;
        }

        @Override
        public final Builder sourcePolicyType(PolicySourceType sourcePolicyType) {
            this.sourcePolicyType(sourcePolicyType.toString());
            return this;
        }

        public final void setSourcePolicyType(String sourcePolicyType) {
            this.sourcePolicyType = sourcePolicyType;
        }

        public final void setSourcePolicyType(PolicySourceType sourcePolicyType) {
            this.sourcePolicyType(sourcePolicyType.toString());
        }

        public final Position getStartPosition() {
            return this.startPosition;
        }

        @Override
        public final Builder startPosition(Position startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final void setStartPosition(Position startPosition) {
            this.startPosition = startPosition;
        }

        public final Position getEndPosition() {
            return this.endPosition;
        }

        @Override
        public final Builder endPosition(Position endPosition) {
            this.endPosition = endPosition;
            return this;
        }

        public final void setEndPosition(Position endPosition) {
            this.endPosition = endPosition;
        }

        public Statement build() {
            return new Statement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Statement> {
        public Builder sourcePolicyId(String var1);

        public Builder sourcePolicyType(String var1);

        public Builder sourcePolicyType(PolicySourceType var1);

        public Builder startPosition(Position var1);

        public Builder endPosition(Position var1);
    }
}

