/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyGroupListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyRoleListTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyUser;
import software.amazon.awssdk.services.iam.model.PolicyUserListTypeCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListEntitiesForPolicyResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
    private final List<PolicyGroup> policyGroups;
    private final List<PolicyUser> policyUsers;
    private final List<PolicyRole> policyRoles;
    private final Boolean isTruncated;
    private final String marker;

    private ListEntitiesForPolicyResponse(BuilderImpl builder) {
        this.policyGroups = builder.policyGroups;
        this.policyUsers = builder.policyUsers;
        this.policyRoles = builder.policyRoles;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public List<PolicyGroup> policyGroups() {
        return this.policyGroups;
    }

    public List<PolicyUser> policyUsers() {
        return this.policyUsers;
    }

    public List<PolicyRole> policyRoles() {
        return this.policyRoles;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.policyGroups() == null ? 0 : this.policyGroups().hashCode());
        hashCode = 31 * hashCode + (this.policyUsers() == null ? 0 : this.policyUsers().hashCode());
        hashCode = 31 * hashCode + (this.policyRoles() == null ? 0 : this.policyRoles().hashCode());
        hashCode = 31 * hashCode + (this.isTruncated() == null ? 0 : this.isTruncated().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesForPolicyResponse)) {
            return false;
        }
        ListEntitiesForPolicyResponse other = (ListEntitiesForPolicyResponse)((Object)obj);
        if (other.policyGroups() == null ^ this.policyGroups() == null) {
            return false;
        }
        if (other.policyGroups() != null && !other.policyGroups().equals(this.policyGroups())) {
            return false;
        }
        if (other.policyUsers() == null ^ this.policyUsers() == null) {
            return false;
        }
        if (other.policyUsers() != null && !other.policyUsers().equals(this.policyUsers())) {
            return false;
        }
        if (other.policyRoles() == null ^ this.policyRoles() == null) {
            return false;
        }
        if (other.policyRoles() != null && !other.policyRoles().equals(this.policyRoles())) {
            return false;
        }
        if (other.isTruncated() == null ^ this.isTruncated() == null) {
            return false;
        }
        if (other.isTruncated() != null && !other.isTruncated().equals(this.isTruncated())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.policyGroups() != null) {
            sb.append("PolicyGroups: ").append(this.policyGroups()).append(",");
        }
        if (this.policyUsers() != null) {
            sb.append("PolicyUsers: ").append(this.policyUsers()).append(",");
        }
        if (this.policyRoles() != null) {
            sb.append("PolicyRoles: ").append(this.policyRoles()).append(",");
        }
        if (this.isTruncated() != null) {
            sb.append("IsTruncated: ").append(this.isTruncated()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<PolicyGroup> policyGroups = new SdkInternalList();
        private List<PolicyUser> policyUsers = new SdkInternalList();
        private List<PolicyRole> policyRoles = new SdkInternalList();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesForPolicyResponse model) {
            this.setPolicyGroups(model.policyGroups);
            this.setPolicyUsers(model.policyUsers);
            this.setPolicyRoles(model.policyRoles);
            this.setIsTruncated(model.isTruncated);
            this.setMarker(model.marker);
        }

        public final Collection<PolicyGroup> getPolicyGroups() {
            return this.policyGroups;
        }

        @Override
        public final Builder policyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyGroups(PolicyGroup ... policyGroups) {
            if (this.policyGroups == null) {
                this.policyGroups = new SdkInternalList(policyGroups.length);
            }
            for (PolicyGroup e : policyGroups) {
                this.policyGroups.add(e);
            }
            return this;
        }

        public final void setPolicyGroups(Collection<PolicyGroup> policyGroups) {
            this.policyGroups = PolicyGroupListTypeCopier.copy(policyGroups);
        }

        @SafeVarargs
        public final void setPolicyGroups(PolicyGroup ... policyGroups) {
            if (this.policyGroups == null) {
                this.policyGroups = new SdkInternalList(policyGroups.length);
            }
            for (PolicyGroup e : policyGroups) {
                this.policyGroups.add(e);
            }
        }

        public final Collection<PolicyUser> getPolicyUsers() {
            return this.policyUsers;
        }

        @Override
        public final Builder policyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyUsers(PolicyUser ... policyUsers) {
            if (this.policyUsers == null) {
                this.policyUsers = new SdkInternalList(policyUsers.length);
            }
            for (PolicyUser e : policyUsers) {
                this.policyUsers.add(e);
            }
            return this;
        }

        public final void setPolicyUsers(Collection<PolicyUser> policyUsers) {
            this.policyUsers = PolicyUserListTypeCopier.copy(policyUsers);
        }

        @SafeVarargs
        public final void setPolicyUsers(PolicyUser ... policyUsers) {
            if (this.policyUsers == null) {
                this.policyUsers = new SdkInternalList(policyUsers.length);
            }
            for (PolicyUser e : policyUsers) {
                this.policyUsers.add(e);
            }
        }

        public final Collection<PolicyRole> getPolicyRoles() {
            return this.policyRoles;
        }

        @Override
        public final Builder policyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyRoles(PolicyRole ... policyRoles) {
            if (this.policyRoles == null) {
                this.policyRoles = new SdkInternalList(policyRoles.length);
            }
            for (PolicyRole e : policyRoles) {
                this.policyRoles.add(e);
            }
            return this;
        }

        public final void setPolicyRoles(Collection<PolicyRole> policyRoles) {
            this.policyRoles = PolicyRoleListTypeCopier.copy(policyRoles);
        }

        @SafeVarargs
        public final void setPolicyRoles(PolicyRole ... policyRoles) {
            if (this.policyRoles == null) {
                this.policyRoles = new SdkInternalList(policyRoles.length);
            }
            for (PolicyRole e : policyRoles) {
                this.policyRoles.add(e);
            }
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public ListEntitiesForPolicyResponse build() {
            return new ListEntitiesForPolicyResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListEntitiesForPolicyResponse> {
        public Builder policyGroups(Collection<PolicyGroup> var1);

        public Builder policyGroups(PolicyGroup ... var1);

        public Builder policyUsers(Collection<PolicyUser> var1);

        public Builder policyUsers(PolicyUser ... var1);

        public Builder policyRoles(Collection<PolicyRole> var1);

        public Builder policyRoles(PolicyRole ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

