/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.policybuilder.iam.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotNull;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.policybuilder.iam.IamAction;
import software.amazon.awssdk.policybuilder.iam.IamCondition;
import software.amazon.awssdk.policybuilder.iam.IamConditionKey;
import software.amazon.awssdk.policybuilder.iam.IamConditionOperator;
import software.amazon.awssdk.policybuilder.iam.IamEffect;
import software.amazon.awssdk.policybuilder.iam.IamPrincipal;
import software.amazon.awssdk.policybuilder.iam.IamPrincipalType;
import software.amazon.awssdk.policybuilder.iam.IamResource;
import software.amazon.awssdk.policybuilder.iam.IamStatement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultIamStatement
implements IamStatement {
    private final String sid;
    @NotNull
    private final IamEffect effect;
    @NotNull
    private final List<IamPrincipal> principals;
    @NotNull
    private final List<IamPrincipal> notPrincipals;
    @NotNull
    private final List<IamAction> actions;
    @NotNull
    private final List<IamAction> notActions;
    @NotNull
    private final List<IamResource> resources;
    @NotNull
    private final List<IamResource> notResources;
    @NotNull
    private final List<IamCondition> conditions;

    public DefaultIamStatement(Builder builder) {
        this.sid = builder.sid;
        this.effect = (IamEffect)Validate.paramNotNull((Object)builder.effect, (String)"statementEffect");
        this.principals = new ArrayList<IamPrincipal>(builder.principals);
        this.notPrincipals = new ArrayList<IamPrincipal>(builder.notPrincipals);
        this.actions = new ArrayList<IamAction>(builder.actions);
        this.notActions = new ArrayList<IamAction>(builder.notActions);
        this.resources = new ArrayList<IamResource>(builder.resources);
        this.notResources = new ArrayList<IamResource>(builder.notResources);
        this.conditions = new ArrayList<IamCondition>(builder.conditions);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String sid() {
        return this.sid;
    }

    @Override
    public IamEffect effect() {
        return this.effect;
    }

    @Override
    public List<IamPrincipal> principals() {
        return Collections.unmodifiableList(this.principals);
    }

    @Override
    public List<IamPrincipal> notPrincipals() {
        return Collections.unmodifiableList(this.notPrincipals);
    }

    @Override
    public List<IamAction> actions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public List<IamAction> notActions() {
        return Collections.unmodifiableList(this.notActions);
    }

    @Override
    public List<IamResource> resources() {
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public List<IamResource> notResources() {
        return Collections.unmodifiableList(this.notResources);
    }

    @Override
    public List<IamCondition> conditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public IamStatement.Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultIamStatement that = (DefaultIamStatement)o;
        if (!Objects.equals(this.sid, that.sid)) {
            return false;
        }
        if (!this.effect.equals(that.effect)) {
            return false;
        }
        if (!this.principals.equals(that.principals)) {
            return false;
        }
        if (!this.notPrincipals.equals(that.notPrincipals)) {
            return false;
        }
        if (!this.actions.equals(that.actions)) {
            return false;
        }
        if (!this.notActions.equals(that.notActions)) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        if (!this.notResources.equals(that.notResources)) {
            return false;
        }
        return this.conditions.equals(that.conditions);
    }

    public int hashCode() {
        int result = this.sid != null ? this.sid.hashCode() : 0;
        result = 31 * result + this.effect.hashCode();
        result = 31 * result + this.principals.hashCode();
        result = 31 * result + this.notPrincipals.hashCode();
        result = 31 * result + this.actions.hashCode();
        result = 31 * result + this.notActions.hashCode();
        result = 31 * result + this.resources.hashCode();
        result = 31 * result + this.notResources.hashCode();
        result = 31 * result + this.conditions.hashCode();
        return result;
    }

    public String toString() {
        return ToString.builder((String)"IamStatement").add("sid", (Object)this.sid).add("effect", (Object)this.effect).add("principals", this.principals.isEmpty() ? null : this.principals).add("notPrincipals", this.notPrincipals.isEmpty() ? null : this.notPrincipals).add("actions", this.actions.isEmpty() ? null : this.actions).add("notActions", this.notActions.isEmpty() ? null : this.notActions).add("resources", this.resources.isEmpty() ? null : this.resources).add("notResources", this.notResources.isEmpty() ? null : this.notResources).add("conditions", this.conditions.isEmpty() ? null : this.conditions).build();
    }

    public static class Builder
    implements IamStatement.Builder {
        private String sid;
        private IamEffect effect;
        private final List<IamPrincipal> principals = new ArrayList<IamPrincipal>();
        private final List<IamPrincipal> notPrincipals = new ArrayList<IamPrincipal>();
        private final List<IamAction> actions = new ArrayList<IamAction>();
        private final List<IamAction> notActions = new ArrayList<IamAction>();
        private final List<IamResource> resources = new ArrayList<IamResource>();
        private final List<IamResource> notResources = new ArrayList<IamResource>();
        private final List<IamCondition> conditions = new ArrayList<IamCondition>();

        private Builder() {
        }

        private Builder(DefaultIamStatement statement) {
            this.sid = statement.sid;
            this.effect = statement.effect;
            this.principals.addAll(statement.principals);
            this.notPrincipals.addAll(statement.notPrincipals);
            this.actions.addAll(statement.actions);
            this.notActions.addAll(statement.notActions);
            this.resources.addAll(statement.resources);
            this.notResources.addAll(statement.notResources);
            this.conditions.addAll(statement.conditions);
        }

        @Override
        public IamStatement.Builder sid(String sid) {
            this.sid = sid;
            return this;
        }

        @Override
        public IamStatement.Builder effect(IamEffect effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public IamStatement.Builder effect(String effect) {
            this.effect = IamEffect.create(effect);
            return this;
        }

        @Override
        public IamStatement.Builder principals(Collection<IamPrincipal> principals) {
            this.principals.clear();
            if (principals != null) {
                this.principals.addAll(principals);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addPrincipal(IamPrincipal principal) {
            Validate.paramNotNull((Object)principal, (String)"principal");
            this.principals.add(principal);
            return this;
        }

        @Override
        public IamStatement.Builder addPrincipal(Consumer<IamPrincipal.Builder> principal) {
            Validate.paramNotNull(principal, (String)"principal");
            this.principals.add((IamPrincipal)((IamPrincipal.Builder)IamPrincipal.builder().applyMutation(principal)).build());
            return this;
        }

        @Override
        public IamStatement.Builder addPrincipal(IamPrincipalType iamPrincipalType, String principal) {
            return this.addPrincipal(IamPrincipal.create(iamPrincipalType, principal));
        }

        @Override
        public IamStatement.Builder addPrincipal(String iamPrincipalType, String principal) {
            return this.addPrincipal(IamPrincipal.create(iamPrincipalType, principal));
        }

        @Override
        public IamStatement.Builder addPrincipals(IamPrincipalType principalType, Collection<String> principals) {
            Validate.paramNotNull((Object)principalType, (String)"principals");
            for (String principal : principals) {
                this.principals.add(IamPrincipal.create(principalType, principal));
            }
            return this;
        }

        @Override
        public IamStatement.Builder addPrincipals(String principalType, Collection<String> principals) {
            return this.addPrincipals(IamPrincipalType.create(principalType), principals);
        }

        @Override
        public IamStatement.Builder notPrincipals(Collection<IamPrincipal> notPrincipals) {
            this.notPrincipals.clear();
            if (notPrincipals != null) {
                this.notPrincipals.addAll(notPrincipals);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addNotPrincipal(IamPrincipal notPrincipal) {
            Validate.paramNotNull((Object)notPrincipal, (String)"notPrincipal");
            this.notPrincipals.add(notPrincipal);
            return this;
        }

        @Override
        public IamStatement.Builder addNotPrincipal(Consumer<IamPrincipal.Builder> notPrincipal) {
            Validate.paramNotNull(notPrincipal, (String)"notPrincipal");
            this.notPrincipals.add((IamPrincipal)((IamPrincipal.Builder)IamPrincipal.builder().applyMutation(notPrincipal)).build());
            return this;
        }

        @Override
        public IamStatement.Builder addNotPrincipal(IamPrincipalType iamPrincipalType, String principal) {
            return this.addNotPrincipal(IamPrincipal.create(iamPrincipalType, principal));
        }

        @Override
        public IamStatement.Builder addNotPrincipal(String iamPrincipalType, String principal) {
            return this.addNotPrincipal(IamPrincipal.create(iamPrincipalType, principal));
        }

        @Override
        public IamStatement.Builder addNotPrincipals(IamPrincipalType notPrincipalType, Collection<String> notPrincipals) {
            Validate.paramNotNull(notPrincipals, (String)"notPrincipals");
            for (String notPrincipal : notPrincipals) {
                this.notPrincipals.add(IamPrincipal.create(notPrincipalType, notPrincipal));
            }
            return this;
        }

        @Override
        public IamStatement.Builder addNotPrincipals(String notPrincipalType, Collection<String> notPrincipals) {
            return this.addNotPrincipals(IamPrincipalType.create(notPrincipalType), notPrincipals);
        }

        @Override
        public IamStatement.Builder actions(Collection<IamAction> actions) {
            this.actions.clear();
            if (actions != null) {
                this.actions.addAll(actions);
            }
            return this;
        }

        @Override
        public IamStatement.Builder actionIds(Collection<String> actions) {
            this.actions.clear();
            if (actions != null) {
                actions.forEach(this::addAction);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addAction(IamAction action) {
            Validate.paramNotNull((Object)action, (String)"action");
            this.actions.add(action);
            return this;
        }

        @Override
        public IamStatement.Builder addAction(String action) {
            this.actions.add(IamAction.create(action));
            return this;
        }

        @Override
        public IamStatement.Builder notActions(Collection<IamAction> notActions) {
            this.notActions.clear();
            if (notActions != null) {
                this.notActions.addAll(notActions);
            }
            return this;
        }

        @Override
        public IamStatement.Builder notActionIds(Collection<String> notActions) {
            this.notActions.clear();
            if (notActions != null) {
                notActions.forEach(this::addNotAction);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addNotAction(IamAction notAction) {
            Validate.paramNotNull((Object)notAction, (String)"notAction");
            this.notActions.add(notAction);
            return this;
        }

        @Override
        public IamStatement.Builder addNotAction(String notAction) {
            this.notActions.add(IamAction.create(notAction));
            return this;
        }

        @Override
        public IamStatement.Builder resources(Collection<IamResource> resources) {
            this.resources.clear();
            if (resources != null) {
                this.resources.addAll(resources);
            }
            return this;
        }

        @Override
        public IamStatement.Builder resourceIds(Collection<String> resources) {
            this.resources.clear();
            if (resources != null) {
                resources.forEach(this::addResource);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addResource(IamResource resource) {
            Validate.paramNotNull((Object)resource, (String)"resource");
            this.resources.add(resource);
            return this;
        }

        @Override
        public IamStatement.Builder addResource(String resource) {
            this.resources.add(IamResource.create(resource));
            return this;
        }

        @Override
        public IamStatement.Builder notResources(Collection<IamResource> notResources) {
            this.notResources.clear();
            if (notResources != null) {
                this.notResources.addAll(notResources);
            }
            return this;
        }

        @Override
        public IamStatement.Builder notResourceIds(Collection<String> notResources) {
            this.notResources.clear();
            if (notResources != null) {
                notResources.forEach(this::addNotResource);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addNotResource(IamResource notResource) {
            this.notResources.add(notResource);
            return this;
        }

        @Override
        public IamStatement.Builder addNotResource(String notResource) {
            this.notResources.add(IamResource.create(notResource));
            return this;
        }

        @Override
        public IamStatement.Builder conditions(Collection<IamCondition> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @Override
        public IamStatement.Builder addCondition(IamCondition condition) {
            Validate.paramNotNull((Object)condition, (String)"condition");
            this.conditions.add(condition);
            return this;
        }

        @Override
        public IamStatement.Builder addCondition(Consumer<IamCondition.Builder> condition) {
            Validate.paramNotNull(condition, (String)"condition");
            this.conditions.add((IamCondition)((IamCondition.Builder)IamCondition.builder().applyMutation(condition)).build());
            return this;
        }

        @Override
        public IamStatement.Builder addCondition(IamConditionOperator operator, IamConditionKey key, String value) {
            this.conditions.add(IamCondition.create(operator, key, value));
            return this;
        }

        @Override
        public IamStatement.Builder addCondition(IamConditionOperator operator, String key, String value) {
            return this.addCondition(operator, IamConditionKey.create(key), value);
        }

        @Override
        public IamStatement.Builder addCondition(String operator, String key, String value) {
            this.conditions.add(IamCondition.create(operator, key, value));
            return this;
        }

        @Override
        public IamStatement.Builder addConditions(IamConditionOperator operator, IamConditionKey key, Collection<String> values) {
            Validate.paramNotNull(values, (String)"values");
            for (String value : values) {
                this.conditions.add(IamCondition.create(operator, key, value));
            }
            return this;
        }

        @Override
        public IamStatement.Builder addConditions(IamConditionOperator operator, String key, Collection<String> values) {
            return this.addConditions(operator, IamConditionKey.create(key), values);
        }

        @Override
        public IamStatement.Builder addConditions(String operator, String key, Collection<String> values) {
            return this.addConditions(IamConditionOperator.create(operator), IamConditionKey.create(key), values);
        }

        public IamStatement build() {
            return new DefaultIamStatement(this);
        }
    }
}

