/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.TlsKeyManagersProvider;
import software.amazon.awssdk.utils.Logger;

public class MockServer {
    private static final Logger logger = Logger.loggerFor(MockServer.class);
    private final ServerBehaviorStrategy serverBehaviorStrategy;
    private ServerSocket serverSocket;
    private Thread listenerThread;

    public MockServer(ServerBehaviorStrategy serverBehaviorStrategy) {
        this.serverBehaviorStrategy = serverBehaviorStrategy;
    }

    public static MockServer createMockServer(ServerBehavior serverBehavior) {
        switch (serverBehavior) {
            case HALF_CLOSE: {
                if (!MockServer.isTlsHalfCloseSupported()) {
                    throw new UnsupportedOperationException("Half close is not supported in the current Java Version " + MockServer.getJavaVersion());
                }
                return new MockServer(new HalfCloseServerBehavior());
            }
            case FULL_CLOSE_IN_BETWEEN: {
                return new MockServer(new FullCloseInBetweenServerBehavior());
            }
            case FULL_CLOSE_AT_THE_END: {
                return new MockServer(new FullCloseAtTheEndServerBehavior());
            }
        }
        throw new IllegalArgumentException("Unsupported implementation for server issue: " + (Object)((Object)serverBehavior));
    }

    private static Map<String, String> parseHeaders(String headers) {
        String[] lines;
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String line : lines = headers.split("\r\n")) {
            if (!line.contains(":")) continue;
            String[] parts = line.split(":", 2);
            headerMap.put(parts[0].trim(), parts[1].trim());
        }
        return headerMap;
    }

    private static String toByteToString(ByteArrayOutputStream baos) {
        return StandardCharsets.UTF_8.decode(ByteBuffer.wrap(baos.toByteArray())).toString();
    }

    public void startServer(TlsKeyManagersProvider keyManagersProvider) {
        try {
            SSLContext ctx = SSLContext.getInstance("SSL");
            ctx.init(keyManagersProvider.keyManagers(), null, null);
            SSLServerSocketFactory ssf = ctx.getServerSocketFactory();
            this.serverSocket = ssf.createServerSocket(0);
            logger.info(() -> "Listening on port " + this.serverSocket.getLocalPort());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start the server socket.", e);
        }
        this.listenerThread = new MockServerListenerThread(this.serverSocket, this.serverBehaviorStrategy);
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public void stopServer() {
        this.listenerThread.interrupt();
        try {
            this.listenerThread.join(5000L);
        }
        catch (InterruptedException e1) {
            logger.error(() -> "The listener thread didn't terminate after waiting for 10 seconds.");
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to stop the server socket.", e);
            }
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public SdkHttpFullRequest.Builder configureHttpsEndpoint(SdkHttpFullRequest.Builder request) {
        return request.uri(URI.create("https://localhost")).port(Integer.valueOf(this.getPort()));
    }

    public SdkHttpFullRequest.Builder configureHttpEndpoint(SdkHttpFullRequest.Builder request) {
        return request.uri(URI.create("http://localhost")).port(Integer.valueOf(this.getPort()));
    }

    public static boolean isTlsHalfCloseSupported() {
        String javaVersion = MockServer.getJavaVersion();
        String[] versionComponents = javaVersion.split("_");
        if (versionComponents.length == 2) {
            try {
                int buildNumber = Integer.parseInt(versionComponents[1].split("-")[0]);
                if (javaVersion.startsWith("1.8.0") && buildNumber < 341) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                logger.error(() -> "Invalid Java version format: " + javaVersion);
                throw e;
            }
        }
        return true;
    }

    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception ex) {
                logger.debug(() -> "Ignore failure in closing the socket", (Throwable)ex);
            }
        }
    }

    private static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static class FullCloseAtTheEndServerBehavior
    implements ServerBehaviorStrategy {
        @Override
        public void runServer(ServerSocket serverSocket) {
            Socket socket = null;
            try {
                try {
                    String headers;
                    int read;
                    socket = serverSocket.accept();
                    ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
                    byte[] buff = new byte[4096];
                    while ((read = socket.getInputStream().read(buff)) != -1) {
                        headerStream.write(buff, 0, read);
                        headers = MockServer.toByteToString(headerStream);
                        if (!headers.contains("\r\n\r\n")) continue;
                        break;
                    }
                    headers = MockServer.toByteToString(headerStream);
                    Map headerMap = MockServer.parseHeaders(headers);
                    int contentLength = Integer.parseInt(headerMap.getOrDefault("Content-Length", "0"));
                    if (headers.startsWith("PUT")) {
                        ByteArrayOutputStream bodyStream = new ByteArrayOutputStream();
                        for (int remaining = contentLength; remaining > 0 && (read = socket.getInputStream().read(buff, 0, Math.min(buff.length, remaining))) != -1; remaining -= read) {
                            bodyStream.write(buff, 0, read);
                        }
                    }
                    try (DataOutputStream out = new DataOutputStream(socket.getOutputStream());){
                        out.writeBytes("HTTP/1.1 200 OK\r\n");
                        out.writeBytes("Content-Type: text/html\r\n");
                        out.writeBytes("Content-Length: 0\r\n\r\n");
                        out.flush();
                    }
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (SocketException se) {
                    MockServer.closeQuietly(socket);
                    return;
                }
                catch (InterruptedException e) {
                    MockServer.closeQuietly(socket);
                    return;
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Error when waiting for new socket connection.", e);
                }
                catch (Throwable throwable) {
                    MockServer.closeQuietly(socket);
                    throw throwable;
                }
            }
        }
    }

    public static class FullCloseInBetweenServerBehavior
    implements ServerBehaviorStrategy {
        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void runServer(ServerSocket serverSocket) {
            Socket socket = null;
            try {
                try {}
                catch (SocketException se) {
                    MockServer.closeQuietly(socket);
                    return;
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Error when waiting for new socket connection.", e);
                }
                catch (Throwable throwable) {
                    MockServer.closeQuietly(socket);
                    throw throwable;
                }
            }
            while (true) {
                int read;
                socket = serverSocket.accept();
                byte[] buff = new byte[4096];
                ByteArrayOutputStream headerStream = new ByteArrayOutputStream();
                while ((read = socket.getInputStream().read(buff)) != -1) {
                    headerStream.write(buff, 0, read);
                    String headers = MockServer.toByteToString(headerStream);
                    if (!headers.contains("\r\n\r\n")) continue;
                }
                socket.close();
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                try {
                    out.writeBytes("HTTP/1.1 200 OK\r\n");
                    out.writeBytes("Content-Type: text/html\r\n");
                    out.writeBytes("Content-Length: 0\r\n\r\n");
                    out.flush();
                    continue;
                }
                finally {
                    out.close();
                    continue;
                }
                break;
            }
        }
    }

    public static class HalfCloseServerBehavior
    implements ServerBehaviorStrategy {
        /*
         * Unable to fully structure code
         */
        @Override
        public void runServer(ServerSocket serverSocket) {
            socket = null;
            try {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        socket = serverSocket.accept();
                        buff = new byte[4096];
                        headerStream = new ByteArrayOutputStream();
                        while ((read = socket.getInputStream().read(buff)) != -1) {
                            headerStream.write(buff, 0, read);
                            headers = MockServer.access$000(headerStream);
                            if (!headers.contains("\r\n\r\n")) continue;
                            break;
                        }
                        Thread.sleep(100L);
                        socket.shutdownOutput();
                        out = new DataOutputStream(socket.getOutputStream());
                        try {
                            out.writeBytes("HTTP/1.1 200 OK\r\n");
                            out.writeBytes("Content-Type: text/html\r\n");
                            out.writeBytes("Content-Length: 0\r\n\r\n");
                            out.flush();
                        }
                        finally {
                            out.close();
                            continue;
                        }
                        break;
                    }
                }
                catch (SocketException se) {
                    MockServer.closeQuietly(socket);
                    return;
                }
                catch (InterruptedException e) {
                    MockServer.closeQuietly(socket);
                    return;
                }
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException("Error when waiting for new socket connection.", e);
                }
                catch (Throwable var9_12) {
                    MockServer.closeQuietly(socket);
                    throw var9_12;
                }
            }
        }
    }

    private static class MockServerListenerThread
    extends Thread {
        private final ServerSocket serverSocket;
        private final ServerBehaviorStrategy behaviorStrategy;

        MockServerListenerThread(ServerSocket serverSocket, ServerBehaviorStrategy behaviorStrategy) {
            super(behaviorStrategy.getClass().getName());
            this.serverSocket = serverSocket;
            this.behaviorStrategy = behaviorStrategy;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            this.behaviorStrategy.runServer(this.serverSocket);
        }
    }

    public static interface ServerBehaviorStrategy {
        public void runServer(ServerSocket var1);
    }

    public static enum ServerBehavior {
        HALF_CLOSE,
        FULL_CLOSE_IN_BETWEEN,
        FULL_CLOSE_AT_THE_END;

    }
}

