/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;

public class EmptyPublisher
implements SdkHttpContentPublisher {
    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
    }

    public Optional<Long> contentLength() {
        return Optional.of(0L);
    }

    private static class EmptySubscription
    implements Subscription {
        private final Subscriber subscriber;
        private volatile boolean done;

        EmptySubscription(Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        public void request(long l) {
            if (!this.done) {
                this.done = true;
                if (l <= 0L) {
                    this.subscriber.onError((Throwable)new IllegalArgumentException("Demand must be positive"));
                } else {
                    this.subscriber.onComplete();
                }
            }
        }

        public void cancel() {
            this.done = true;
        }
    }
}

