/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.net.URI;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.SdkHttpHeaders;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkPublicApi
@Immutable
public interface SdkHttpRequest
extends SdkHttpHeaders {
    public String protocol();

    public String host();

    public int port();

    public String encodedPath();

    public Map<String, List<String>> rawQueryParameters();

    default public URI getUri() {
        String encodedQueryString = SdkHttpUtils.encodeAndFlattenQueryParameters(this.rawQueryParameters()).map(value -> "?" + value).orElse("");
        String portString = SdkHttpUtils.isUsingStandardPort((String)this.protocol(), (Integer)this.port()) ? "" : ":" + this.port();
        return URI.create(this.protocol() + "://" + this.host() + portString + this.encodedPath() + encodedQueryString);
    }

    public SdkHttpMethod method();
}

