/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.http.HandlerContextKey;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public interface SdkHttpFullRequest
extends SdkHttpRequest,
ToCopyableBuilder<Builder, SdkHttpFullRequest> {
    public InputStream getContent();

    public static interface Builder
    extends CopyableBuilder<Builder, SdkHttpFullRequest>,
    SdkHttpRequest {
        default public Builder header(String key, String value) {
            return this.header(key, Collections.singletonList(value));
        }

        public Builder header(String var1, List<String> var2);

        public Builder headers(Map<String, List<String>> var1);

        public Builder resourcePath(String var1);

        default public Builder queryParameter(String paramName, String paramValue) {
            return this.queryParameter(paramName, Collections.singletonList(paramValue));
        }

        public Builder queryParameter(String var1, List<String> var2);

        public Builder queryParameters(Map<String, List<String>> var1);

        public Builder removeQueryParameter(String var1);

        public Builder clearQueryParameters();

        public Builder endpoint(URI var1);

        public Builder httpMethod(SdkHttpMethod var1);

        public Builder content(InputStream var1);

        public InputStream getContent();

        public <T> Builder handlerContext(HandlerContextKey<T> var1, T var2);
    }
}

