/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.DefaultSdkHttpFullResponse;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkProtectedApi
@Immutable
public interface SdkHttpFullResponse
extends SdkHttpResponse,
ToCopyableBuilder<Builder, SdkHttpFullResponse> {
    public static Builder builder() {
        return new DefaultSdkHttpFullResponse.Builder();
    }

    public Optional<AbortableInputStream> content();

    public static interface Builder
    extends CopyableBuilder<Builder, SdkHttpFullResponse> {
        public String statusText();

        public Builder statusText(String var1);

        public int statusCode();

        public Builder statusCode(int var1);

        public Map<String, List<String>> headers();

        default public Optional<String> firstMatchingHeader(String header) {
            return SdkHttpUtils.firstMatchingHeader(this.headers(), (String)header);
        }

        default public Builder putHeader(String headerName, String headerValue) {
            return this.putHeader(headerName, Collections.singletonList(headerValue));
        }

        public Builder putHeader(String var1, List<String> var2);

        public Builder appendHeader(String var1, String var2);

        public Builder headers(Map<String, List<String>> var1);

        public Builder removeHeader(String var1);

        public Builder clearHeaders();

        public AbortableInputStream content();

        public Builder content(AbortableInputStream var1);
    }
}

