/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import software.amazon.awssdk.annotation.Immutable;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.SdkHttpFullResponse;

@SdkInternalApi
@Immutable
class DefaultSdkHttpFullResponse
implements SdkHttpFullResponse {
    private final String statusText;
    private final int statusCode;
    private final AbortableInputStream content;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);

    DefaultSdkHttpFullResponse(SdkHttpFullResponse.Builder builder) {
        this.statusCode = builder.statusCode;
        this.statusText = builder.statusText;
        this.content = builder.content;
        this.headers.putAll(builder.headers);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Collection<String> getValuesForHeader(String header) {
        List<String> values = this.headers.get(header);
        return values != null ? values : Collections.emptyList();
    }

    @Override
    public AbortableInputStream getContent() {
        return this.content;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }
}

