/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.honeycode.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.honeycode.HoneycodeClient;
import software.amazon.awssdk.services.honeycode.internal.UserAgentUtils;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsRequest;
import software.amazon.awssdk.services.honeycode.model.ListTableRowsResponse;
import software.amazon.awssdk.services.honeycode.model.TableRow;

public class ListTableRowsIterable
implements SdkIterable<ListTableRowsResponse> {
    private final HoneycodeClient client;
    private final ListTableRowsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTableRowsIterable(HoneycodeClient client, ListTableRowsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTableRowsResponseFetcher();
    }

    public Iterator<ListTableRowsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TableRow> rows() {
        Function<ListTableRowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rows() != null) {
                return response.rows().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTableRowsResponseFetcher
    implements SyncPageFetcher<ListTableRowsResponse> {
        private ListTableRowsResponseFetcher() {
        }

        public boolean hasNextPage(ListTableRowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTableRowsResponse nextPage(ListTableRowsResponse previousPage) {
            if (previousPage == null) {
                return ListTableRowsIterable.this.client.listTableRows(ListTableRowsIterable.this.firstRequest);
            }
            return ListTableRowsIterable.this.client.listTableRows((ListTableRowsRequest)((Object)ListTableRowsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

