/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.PortProbeDetail;
import software.amazon.awssdk.services.guardduty.model.PortProbeDetailsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PortProbeAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PortProbeAction> {
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(PortProbeAction.getter(PortProbeAction::blocked)).setter(PortProbeAction.setter(Builder::blocked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()}).build();
    private static final SdkField<List<PortProbeDetail>> PORT_PROBE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(PortProbeAction.getter(PortProbeAction::portProbeDetails)).setter(PortProbeAction.setter(Builder::portProbeDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portProbeDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortProbeDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCKED_FIELD, PORT_PROBE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean blocked;
    private final List<PortProbeDetail> portProbeDetails;

    private PortProbeAction(BuilderImpl builder) {
        this.blocked = builder.blocked;
        this.portProbeDetails = builder.portProbeDetails;
    }

    public Boolean blocked() {
        return this.blocked;
    }

    public List<PortProbeDetail> portProbeDetails() {
        return this.portProbeDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        hashCode = 31 * hashCode + Objects.hashCode(this.portProbeDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortProbeAction)) {
            return false;
        }
        PortProbeAction other = (PortProbeAction)obj;
        return Objects.equals(this.blocked(), other.blocked()) && Objects.equals(this.portProbeDetails(), other.portProbeDetails());
    }

    public String toString() {
        return ToString.builder((String)"PortProbeAction").add("Blocked", (Object)this.blocked()).add("PortProbeDetails", this.portProbeDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
            case "PortProbeDetails": {
                return Optional.ofNullable(clazz.cast(this.portProbeDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortProbeAction, T> g) {
        return obj -> g.apply((PortProbeAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blocked;
        private List<PortProbeDetail> portProbeDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PortProbeAction model) {
            this.blocked(model.blocked);
            this.portProbeDetails(model.portProbeDetails);
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        public final Collection<PortProbeDetail.Builder> getPortProbeDetails() {
            return this.portProbeDetails != null ? (Collection)this.portProbeDetails.stream().map(PortProbeDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portProbeDetails(Collection<PortProbeDetail> portProbeDetails) {
            this.portProbeDetails = PortProbeDetailsCopier.copy(portProbeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(PortProbeDetail ... portProbeDetails) {
            this.portProbeDetails(Arrays.asList(portProbeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portProbeDetails(Consumer<PortProbeDetail.Builder> ... portProbeDetails) {
            this.portProbeDetails(Stream.of(portProbeDetails).map(c -> (PortProbeDetail)((PortProbeDetail.Builder)PortProbeDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortProbeDetails(Collection<PortProbeDetail.BuilderImpl> portProbeDetails) {
            this.portProbeDetails = PortProbeDetailsCopier.copyFromBuilder(portProbeDetails);
        }

        public PortProbeAction build() {
            return new PortProbeAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PortProbeAction> {
        public Builder blocked(Boolean var1);

        public Builder portProbeDetails(Collection<PortProbeDetail> var1);

        public Builder portProbeDetails(PortProbeDetail ... var1);

        public Builder portProbeDetails(Consumer<PortProbeDetail.Builder> ... var1);
    }
}

