/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AccountDetail;
import software.amazon.awssdk.services.guardduty.model.AccountDetailsCopier;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembersRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateMembersRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateMembersRequest.getter(CreateMembersRequest::detectorId)).setter(CreateMembersRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<List<AccountDetail>> ACCOUNT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateMembersRequest.getter(CreateMembersRequest::accountDetails)).setter(CreateMembersRequest.setter(Builder::accountDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, ACCOUNT_DETAILS_FIELD));
    private final String detectorId;
    private final List<AccountDetail> accountDetails;

    private CreateMembersRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.accountDetails = builder.accountDetails;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public List<AccountDetail> accountDetails() {
        return this.accountDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountDetails());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersRequest)) {
            return false;
        }
        CreateMembersRequest other = (CreateMembersRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.accountDetails(), other.accountDetails());
    }

    public String toString() {
        return ToString.builder((String)"CreateMembersRequest").add("DetectorId", (Object)this.detectorId()).add("AccountDetails", this.accountDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AccountDetails": {
                return Optional.ofNullable(clazz.cast(this.accountDetails()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersRequest, T> g) {
        return obj -> g.apply((CreateMembersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private List<AccountDetail> accountDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.accountDetails(model.accountDetails);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final Collection<AccountDetail.Builder> getAccountDetails() {
            return this.accountDetails != null ? (Collection)this.accountDetails.stream().map(AccountDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accountDetails(Collection<AccountDetail> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copy(accountDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(AccountDetail ... accountDetails) {
            this.accountDetails(Arrays.asList(accountDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDetails(Consumer<AccountDetail.Builder> ... accountDetails) {
            this.accountDetails(Stream.of(accountDetails).map(c -> (AccountDetail)((AccountDetail.Builder)AccountDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccountDetails(Collection<AccountDetail.BuilderImpl> accountDetails) {
            this.accountDetails = AccountDetailsCopier.copyFromBuilder(accountDetails);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembersRequest build() {
            return new CreateMembersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembersRequest> {
        public Builder detectorId(String var1);

        public Builder accountDetails(Collection<AccountDetail> var1);

        public Builder accountDetails(AccountDetail ... var1);

        public Builder accountDetails(Consumer<AccountDetail.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

