/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IpSetStatus {
    INACTIVE("INACTIVE"),
    ACTIVATING("ACTIVATING"),
    ACTIVE("ACTIVE"),
    DEACTIVATING("DEACTIVATING"),
    ERROR("ERROR"),
    DELETE_PENDING("DELETE_PENDING"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IpSetStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpSetStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IpSetStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpSetStatus> knownValues() {
        return Stream.of(IpSetStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

