/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.IpSetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIpSetsResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListIpSetsResponse> {
    private static final SdkField<List<String>> IP_SET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListIpSetsResponse.getter(ListIpSetsResponse::ipSetIds)).setter(ListIpSetsResponse.setter(Builder::ipSetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipSetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListIpSetsResponse.getter(ListIpSetsResponse::nextToken)).setter(ListIpSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> ipSetIds;
    private final String nextToken;

    private ListIpSetsResponse(BuilderImpl builder) {
        super(builder);
        this.ipSetIds = builder.ipSetIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> ipSetIds() {
        return this.ipSetIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipSetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIpSetsResponse)) {
            return false;
        }
        ListIpSetsResponse other = (ListIpSetsResponse)((Object)obj);
        return Objects.equals(this.ipSetIds(), other.ipSetIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListIpSetsResponse").add("IpSetIds", this.ipSetIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IpSetIds": {
                return Optional.ofNullable(clazz.cast(this.ipSetIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIpSetsResponse, T> g) {
        return obj -> g.apply((ListIpSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<String> ipSetIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIpSetsResponse model) {
            super(model);
            this.ipSetIds(model.ipSetIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getIpSetIds() {
            return this.ipSetIds;
        }

        @Override
        public final Builder ipSetIds(Collection<String> ipSetIds) {
            this.ipSetIds = IpSetIdsCopier.copy(ipSetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipSetIds(String ... ipSetIds) {
            this.ipSetIds(Arrays.asList(ipSetIds));
            return this;
        }

        public final void setIpSetIds(Collection<String> ipSetIds) {
            this.ipSetIds = IpSetIdsCopier.copy(ipSetIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIpSetsResponse build() {
            return new ListIpSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIpSetsResponse> {
        public Builder ipSetIds(Collection<String> var1);

        public Builder ipSetIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

