/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.Scan;
import software.amazon.awssdk.services.guardduty.model.ScansCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMalwareScansResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, DescribeMalwareScansResponse> {
    private static final SdkField<List<Scan>> SCANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Scans").getter(DescribeMalwareScansResponse.getter(DescribeMalwareScansResponse::scans)).setter(DescribeMalwareScansResponse.setter(Builder::scans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Scan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMalwareScansResponse.getter(DescribeMalwareScansResponse::nextToken)).setter(DescribeMalwareScansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMalwareScansResponse.memberNameToFieldInitializer();
    private final List<Scan> scans;
    private final String nextToken;

    private DescribeMalwareScansResponse(BuilderImpl builder) {
        super(builder);
        this.scans = builder.scans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasScans() {
        return this.scans != null && !(this.scans instanceof SdkAutoConstructList);
    }

    public final List<Scan> scans() {
        return this.scans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScans() ? this.scans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMalwareScansResponse)) {
            return false;
        }
        DescribeMalwareScansResponse other = (DescribeMalwareScansResponse)((Object)obj);
        return this.hasScans() == other.hasScans() && Objects.equals(this.scans(), other.scans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMalwareScansResponse").add("Scans", this.hasScans() ? this.scans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scans": {
                return Optional.ofNullable(clazz.cast(this.scans()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scans", SCANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMalwareScansResponse, T> g) {
        return obj -> g.apply((DescribeMalwareScansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<Scan> scans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMalwareScansResponse model) {
            super(model);
            this.scans(model.scans);
            this.nextToken(model.nextToken);
        }

        public final List<Scan.Builder> getScans() {
            List<Scan.Builder> result = ScansCopier.copyToBuilder(this.scans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScans(Collection<Scan.BuilderImpl> scans) {
            this.scans = ScansCopier.copyFromBuilder(scans);
        }

        @Override
        public final Builder scans(Collection<Scan> scans) {
            this.scans = ScansCopier.copy(scans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(Scan ... scans) {
            this.scans(Arrays.asList(scans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scans(Consumer<Scan.Builder> ... scans) {
            this.scans(Stream.of(scans).map(c -> (Scan)((Scan.Builder)Scan.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMalwareScansResponse build() {
            return new DescribeMalwareScansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMalwareScansResponse> {
        public Builder scans(Collection<Scan> var1);

        public Builder scans(Scan ... var1);

        public Builder scans(Consumer<Scan.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

