/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.EqualsCopier;
import software.amazon.awssdk.services.guardduty.model.NotEqualsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageFilterCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageFilterCondition> {
    private static final SdkField<List<String>> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Equals").getter(CoverageFilterCondition.getter(CoverageFilterCondition::equalsValue)).setter(CoverageFilterCondition.setter(Builder::equalsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NOT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotEquals").getter(CoverageFilterCondition.getter(CoverageFilterCondition::notEquals)).setter(CoverageFilterCondition.setter(Builder::notEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUALS_FIELD, NOT_EQUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CoverageFilterCondition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> equals;
    private final List<String> notEquals;

    private CoverageFilterCondition(BuilderImpl builder) {
        this.equals = builder.equals;
        this.notEquals = builder.notEquals;
    }

    public final boolean hasEqualsValue() {
        return this.equals != null && !(this.equals instanceof SdkAutoConstructList);
    }

    public final List<String> equalsValue() {
        return this.equals;
    }

    public final boolean hasNotEquals() {
        return this.notEquals != null && !(this.notEquals instanceof SdkAutoConstructList);
    }

    public final List<String> notEquals() {
        return this.notEquals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEqualsValue() ? this.equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotEquals() ? this.notEquals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageFilterCondition)) {
            return false;
        }
        CoverageFilterCondition other = (CoverageFilterCondition)obj;
        return this.hasEqualsValue() == other.hasEqualsValue() && Objects.equals(this.equalsValue(), other.equalsValue()) && this.hasNotEquals() == other.hasNotEquals() && Objects.equals(this.notEquals(), other.notEquals());
    }

    public final String toString() {
        return ToString.builder((String)"CoverageFilterCondition").add("Equals", this.hasEqualsValue() ? this.equalsValue() : null).add("NotEquals", this.hasNotEquals() ? this.notEquals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
            case "NotEquals": {
                return Optional.ofNullable(clazz.cast(this.notEquals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("equals", EQUALS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CoverageFilterCondition, T> g) {
        return obj -> g.apply((CoverageFilterCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> equals = DefaultSdkAutoConstructList.getInstance();
        private List<String> notEquals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageFilterCondition model) {
            this.equalsValue(model.equals);
            this.notEquals(model.notEquals);
        }

        public final Collection<String> getEqualsValue() {
            if (this.equals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.equals;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = EqualsCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String ... equals) {
            this.equalsValue(Arrays.asList(equals));
            return this;
        }

        public final Collection<String> getNotEquals() {
            if (this.notEquals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.notEquals;
        }

        public final void setNotEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
        }

        @Override
        public final Builder notEquals(Collection<String> notEquals) {
            this.notEquals = NotEqualsCopier.copy(notEquals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notEquals(String ... notEquals) {
            this.notEquals(Arrays.asList(notEquals));
            return this;
        }

        public CoverageFilterCondition build() {
            return new CoverageFilterCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageFilterCondition> {
        public Builder equalsValue(Collection<String> var1);

        public Builder equalsValue(String ... var1);

        public Builder notEquals(Collection<String> var1);

        public Builder notEquals(String ... var1);
    }
}

