/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlanSummary;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionPlansSummaryCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMalwareProtectionPlansResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, ListMalwareProtectionPlansResponse> {
    private static final SdkField<List<MalwareProtectionPlanSummary>> MALWARE_PROTECTION_PLANS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MalwareProtectionPlans").getter(ListMalwareProtectionPlansResponse.getter(ListMalwareProtectionPlansResponse::malwareProtectionPlans)).setter(ListMalwareProtectionPlansResponse.setter(Builder::malwareProtectionPlans)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtectionPlans").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MalwareProtectionPlanSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMalwareProtectionPlansResponse.getter(ListMalwareProtectionPlansResponse::nextToken)).setter(ListMalwareProtectionPlansResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MALWARE_PROTECTION_PLANS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMalwareProtectionPlansResponse.memberNameToFieldInitializer();
    private final List<MalwareProtectionPlanSummary> malwareProtectionPlans;
    private final String nextToken;

    private ListMalwareProtectionPlansResponse(BuilderImpl builder) {
        super(builder);
        this.malwareProtectionPlans = builder.malwareProtectionPlans;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMalwareProtectionPlans() {
        return this.malwareProtectionPlans != null && !(this.malwareProtectionPlans instanceof SdkAutoConstructList);
    }

    public final List<MalwareProtectionPlanSummary> malwareProtectionPlans() {
        return this.malwareProtectionPlans;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMalwareProtectionPlans() ? this.malwareProtectionPlans() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMalwareProtectionPlansResponse)) {
            return false;
        }
        ListMalwareProtectionPlansResponse other = (ListMalwareProtectionPlansResponse)((Object)obj);
        return this.hasMalwareProtectionPlans() == other.hasMalwareProtectionPlans() && Objects.equals(this.malwareProtectionPlans(), other.malwareProtectionPlans()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMalwareProtectionPlansResponse").add("MalwareProtectionPlans", this.hasMalwareProtectionPlans() ? this.malwareProtectionPlans() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MalwareProtectionPlans": {
                return Optional.ofNullable(clazz.cast(this.malwareProtectionPlans()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("malwareProtectionPlans", MALWARE_PROTECTION_PLANS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMalwareProtectionPlansResponse, T> g) {
        return obj -> g.apply((ListMalwareProtectionPlansResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private List<MalwareProtectionPlanSummary> malwareProtectionPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMalwareProtectionPlansResponse model) {
            super(model);
            this.malwareProtectionPlans(model.malwareProtectionPlans);
            this.nextToken(model.nextToken);
        }

        public final List<MalwareProtectionPlanSummary.Builder> getMalwareProtectionPlans() {
            List<MalwareProtectionPlanSummary.Builder> result = MalwareProtectionPlansSummaryCopier.copyToBuilder(this.malwareProtectionPlans);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMalwareProtectionPlans(Collection<MalwareProtectionPlanSummary.BuilderImpl> malwareProtectionPlans) {
            this.malwareProtectionPlans = MalwareProtectionPlansSummaryCopier.copyFromBuilder(malwareProtectionPlans);
        }

        @Override
        public final Builder malwareProtectionPlans(Collection<MalwareProtectionPlanSummary> malwareProtectionPlans) {
            this.malwareProtectionPlans = MalwareProtectionPlansSummaryCopier.copy(malwareProtectionPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareProtectionPlans(MalwareProtectionPlanSummary ... malwareProtectionPlans) {
            this.malwareProtectionPlans(Arrays.asList(malwareProtectionPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder malwareProtectionPlans(Consumer<MalwareProtectionPlanSummary.Builder> ... malwareProtectionPlans) {
            this.malwareProtectionPlans(Stream.of(malwareProtectionPlans).map(c -> (MalwareProtectionPlanSummary)((MalwareProtectionPlanSummary.Builder)MalwareProtectionPlanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMalwareProtectionPlansResponse build() {
            return new ListMalwareProtectionPlansResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMalwareProtectionPlansResponse> {
        public Builder malwareProtectionPlans(Collection<MalwareProtectionPlanSummary> var1);

        public Builder malwareProtectionPlans(MalwareProtectionPlanSummary ... var1);

        public Builder malwareProtectionPlans(Consumer<MalwareProtectionPlanSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

