/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.UnprocessedDataSourcesResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDetectorResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, CreateDetectorResponse> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(CreateDetectorResponse.getter(CreateDetectorResponse::detectorId)).setter(CreateDetectorResponse.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<UnprocessedDataSourcesResult> UNPROCESSED_DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UnprocessedDataSources").getter(CreateDetectorResponse.getter(CreateDetectorResponse::unprocessedDataSources)).setter(CreateDetectorResponse.setter(Builder::unprocessedDataSources)).constructor(UnprocessedDataSourcesResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unprocessedDataSources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, UNPROCESSED_DATA_SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDetectorResponse.memberNameToFieldInitializer();
    private final String detectorId;
    private final UnprocessedDataSourcesResult unprocessedDataSources;

    private CreateDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.unprocessedDataSources = builder.unprocessedDataSources;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final UnprocessedDataSourcesResult unprocessedDataSources() {
        return this.unprocessedDataSources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedDataSources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDetectorResponse)) {
            return false;
        }
        CreateDetectorResponse other = (CreateDetectorResponse)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.unprocessedDataSources(), other.unprocessedDataSources());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDetectorResponse").add("DetectorId", (Object)this.detectorId()).add("UnprocessedDataSources", (Object)this.unprocessedDataSources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "UnprocessedDataSources": {
                return Optional.ofNullable(clazz.cast(this.unprocessedDataSources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("unprocessedDataSources", UNPROCESSED_DATA_SOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDetectorResponse, T> g) {
        return obj -> g.apply((CreateDetectorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String detectorId;
        private UnprocessedDataSourcesResult unprocessedDataSources;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDetectorResponse model) {
            super(model);
            this.detectorId(model.detectorId);
            this.unprocessedDataSources(model.unprocessedDataSources);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final UnprocessedDataSourcesResult.Builder getUnprocessedDataSources() {
            return this.unprocessedDataSources != null ? this.unprocessedDataSources.toBuilder() : null;
        }

        public final void setUnprocessedDataSources(UnprocessedDataSourcesResult.BuilderImpl unprocessedDataSources) {
            this.unprocessedDataSources = unprocessedDataSources != null ? unprocessedDataSources.build() : null;
        }

        @Override
        public final Builder unprocessedDataSources(UnprocessedDataSourcesResult unprocessedDataSources) {
            this.unprocessedDataSources = unprocessedDataSources;
            return this;
        }

        @Override
        public CreateDetectorResponse build() {
            return new CreateDetectorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDetectorResponse> {
        public Builder detectorId(String var1);

        public Builder unprocessedDataSources(UnprocessedDataSourcesResult var1);

        default public Builder unprocessedDataSources(Consumer<UnprocessedDataSourcesResult.Builder> unprocessedDataSources) {
            return this.unprocessedDataSources((UnprocessedDataSourcesResult)((UnprocessedDataSourcesResult.Builder)UnprocessedDataSourcesResult.builder().applyMutation(unprocessedDataSources)).build());
        }
    }
}

