/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.SecurityContext;
import software.amazon.awssdk.services.guardduty.model.VolumeMount;
import software.amazon.awssdk.services.guardduty.model.VolumeMountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Container
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Container> {
    private static final SdkField<String> CONTAINER_RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerRuntime").getter(Container.getter(Container::containerRuntime)).setter(Container.setter(Builder::containerRuntime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRuntime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(Container.getter(Container::id)).setter(Container.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Container.getter(Container::name)).setter(Container.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Image").getter(Container.getter(Container::image)).setter(Container.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> IMAGE_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImagePrefix").getter(Container.getter(Container::imagePrefix)).setter(Container.setter(Builder::imagePrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePrefix").build()}).build();
    private static final SdkField<List<VolumeMount>> VOLUME_MOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VolumeMounts").getter(Container.getter(Container::volumeMounts)).setter(Container.setter(Builder::volumeMounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeMounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeMount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SecurityContext> SECURITY_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityContext").getter(Container.getter(Container::securityContext)).setter(Container.setter(Builder::securityContext)).constructor(SecurityContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityContext").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_RUNTIME_FIELD, ID_FIELD, NAME_FIELD, IMAGE_FIELD, IMAGE_PREFIX_FIELD, VOLUME_MOUNTS_FIELD, SECURITY_CONTEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Container.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerRuntime;
    private final String id;
    private final String name;
    private final String image;
    private final String imagePrefix;
    private final List<VolumeMount> volumeMounts;
    private final SecurityContext securityContext;

    private Container(BuilderImpl builder) {
        this.containerRuntime = builder.containerRuntime;
        this.id = builder.id;
        this.name = builder.name;
        this.image = builder.image;
        this.imagePrefix = builder.imagePrefix;
        this.volumeMounts = builder.volumeMounts;
        this.securityContext = builder.securityContext;
    }

    public final String containerRuntime() {
        return this.containerRuntime;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String image() {
        return this.image;
    }

    public final String imagePrefix() {
        return this.imagePrefix;
    }

    public final boolean hasVolumeMounts() {
        return this.volumeMounts != null && !(this.volumeMounts instanceof SdkAutoConstructList);
    }

    public final List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public final SecurityContext securityContext() {
        return this.securityContext;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRuntime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumeMounts() ? this.volumeMounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.securityContext());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Container)) {
            return false;
        }
        Container other = (Container)obj;
        return Objects.equals(this.containerRuntime(), other.containerRuntime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.imagePrefix(), other.imagePrefix()) && this.hasVolumeMounts() == other.hasVolumeMounts() && Objects.equals(this.volumeMounts(), other.volumeMounts()) && Objects.equals(this.securityContext(), other.securityContext());
    }

    public final String toString() {
        return ToString.builder((String)"Container").add("ContainerRuntime", (Object)this.containerRuntime()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Image", (Object)this.image()).add("ImagePrefix", (Object)this.imagePrefix()).add("VolumeMounts", this.hasVolumeMounts() ? this.volumeMounts() : null).add("SecurityContext", (Object)this.securityContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerRuntime": {
                return Optional.ofNullable(clazz.cast(this.containerRuntime()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "ImagePrefix": {
                return Optional.ofNullable(clazz.cast(this.imagePrefix()));
            }
            case "VolumeMounts": {
                return Optional.ofNullable(clazz.cast(this.volumeMounts()));
            }
            case "SecurityContext": {
                return Optional.ofNullable(clazz.cast(this.securityContext()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containerRuntime", CONTAINER_RUNTIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("image", IMAGE_FIELD);
        map.put("imagePrefix", IMAGE_PREFIX_FIELD);
        map.put("volumeMounts", VOLUME_MOUNTS_FIELD);
        map.put("securityContext", SECURITY_CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Container, T> g) {
        return obj -> g.apply((Container)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerRuntime;
        private String id;
        private String name;
        private String image;
        private String imagePrefix;
        private List<VolumeMount> volumeMounts = DefaultSdkAutoConstructList.getInstance();
        private SecurityContext securityContext;

        private BuilderImpl() {
        }

        private BuilderImpl(Container model) {
            this.containerRuntime(model.containerRuntime);
            this.id(model.id);
            this.name(model.name);
            this.image(model.image);
            this.imagePrefix(model.imagePrefix);
            this.volumeMounts(model.volumeMounts);
            this.securityContext(model.securityContext);
        }

        public final String getContainerRuntime() {
            return this.containerRuntime;
        }

        public final void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        @Override
        public final Builder containerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImagePrefix() {
            return this.imagePrefix;
        }

        public final void setImagePrefix(String imagePrefix) {
            this.imagePrefix = imagePrefix;
        }

        @Override
        public final Builder imagePrefix(String imagePrefix) {
            this.imagePrefix = imagePrefix;
            return this;
        }

        public final List<VolumeMount.Builder> getVolumeMounts() {
            List<VolumeMount.Builder> result = VolumeMountsCopier.copyToBuilder(this.volumeMounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeMounts(Collection<VolumeMount.BuilderImpl> volumeMounts) {
            this.volumeMounts = VolumeMountsCopier.copyFromBuilder(volumeMounts);
        }

        @Override
        public final Builder volumeMounts(Collection<VolumeMount> volumeMounts) {
            this.volumeMounts = VolumeMountsCopier.copy(volumeMounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(VolumeMount ... volumeMounts) {
            this.volumeMounts(Arrays.asList(volumeMounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeMounts(Consumer<VolumeMount.Builder> ... volumeMounts) {
            this.volumeMounts(Stream.of(volumeMounts).map(c -> (VolumeMount)((VolumeMount.Builder)VolumeMount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SecurityContext.Builder getSecurityContext() {
            return this.securityContext != null ? this.securityContext.toBuilder() : null;
        }

        public final void setSecurityContext(SecurityContext.BuilderImpl securityContext) {
            this.securityContext = securityContext != null ? securityContext.build() : null;
        }

        @Override
        public final Builder securityContext(SecurityContext securityContext) {
            this.securityContext = securityContext;
            return this;
        }

        public Container build() {
            return new Container(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Container> {
        public Builder containerRuntime(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder image(String var1);

        public Builder imagePrefix(String var1);

        public Builder volumeMounts(Collection<VolumeMount> var1);

        public Builder volumeMounts(VolumeMount ... var1);

        public Builder volumeMounts(Consumer<VolumeMount.Builder> ... var1);

        public Builder securityContext(SecurityContext var1);

        default public Builder securityContext(Consumer<SecurityContext.Builder> securityContext) {
            return this.securityContext((SecurityContext)((SecurityContext.Builder)SecurityContext.builder().applyMutation(securityContext)).build());
        }
    }
}

