/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnsRequestAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnsRequestAction> {
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(DnsRequestAction.getter(DnsRequestAction::domain)).setter(DnsRequestAction.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(DnsRequestAction.getter(DnsRequestAction::protocol)).setter(DnsRequestAction.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()}).build();
    private static final SdkField<Boolean> BLOCKED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Blocked").getter(DnsRequestAction.getter(DnsRequestAction::blocked)).setter(DnsRequestAction.setter(Builder::blocked)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blocked").build()}).build();
    private static final SdkField<String> DOMAIN_WITH_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainWithSuffix").getter(DnsRequestAction.getter(DnsRequestAction::domainWithSuffix)).setter(DnsRequestAction.setter(Builder::domainWithSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainWithSuffix").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_FIELD, PROTOCOL_FIELD, BLOCKED_FIELD, DOMAIN_WITH_SUFFIX_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnsRequestAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final String protocol;
    private final Boolean blocked;
    private final String domainWithSuffix;

    private DnsRequestAction(BuilderImpl builder) {
        this.domain = builder.domain;
        this.protocol = builder.protocol;
        this.blocked = builder.blocked;
        this.domainWithSuffix = builder.domainWithSuffix;
    }

    public final String domain() {
        return this.domain;
    }

    public final String protocol() {
        return this.protocol;
    }

    public final Boolean blocked() {
        return this.blocked;
    }

    public final String domainWithSuffix() {
        return this.domainWithSuffix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        hashCode = 31 * hashCode + Objects.hashCode(this.blocked());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainWithSuffix());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsRequestAction)) {
            return false;
        }
        DnsRequestAction other = (DnsRequestAction)obj;
        return Objects.equals(this.domain(), other.domain()) && Objects.equals(this.protocol(), other.protocol()) && Objects.equals(this.blocked(), other.blocked()) && Objects.equals(this.domainWithSuffix(), other.domainWithSuffix());
    }

    public final String toString() {
        return ToString.builder((String)"DnsRequestAction").add("Domain", (Object)this.domain()).add("Protocol", (Object)this.protocol()).add("Blocked", (Object)this.blocked()).add("DomainWithSuffix", (Object)this.domainWithSuffix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
            case "Blocked": {
                return Optional.ofNullable(clazz.cast(this.blocked()));
            }
            case "DomainWithSuffix": {
                return Optional.ofNullable(clazz.cast(this.domainWithSuffix()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domain", DOMAIN_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("blocked", BLOCKED_FIELD);
        map.put("domainWithSuffix", DOMAIN_WITH_SUFFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnsRequestAction, T> g) {
        return obj -> g.apply((DnsRequestAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domain;
        private String protocol;
        private Boolean blocked;
        private String domainWithSuffix;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsRequestAction model) {
            this.domain(model.domain);
            this.protocol(model.protocol);
            this.blocked(model.blocked);
            this.domainWithSuffix(model.domainWithSuffix);
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public final Boolean getBlocked() {
            return this.blocked;
        }

        public final void setBlocked(Boolean blocked) {
            this.blocked = blocked;
        }

        @Override
        public final Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public final String getDomainWithSuffix() {
            return this.domainWithSuffix;
        }

        public final void setDomainWithSuffix(String domainWithSuffix) {
            this.domainWithSuffix = domainWithSuffix;
        }

        @Override
        public final Builder domainWithSuffix(String domainWithSuffix) {
            this.domainWithSuffix = domainWithSuffix;
            return this;
        }

        public DnsRequestAction build() {
            return new DnsRequestAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnsRequestAction> {
        public Builder domain(String var1);

        public Builder protocol(String var1);

        public Builder blocked(Boolean var1);

        public Builder domainWithSuffix(String var1);
    }
}

