/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingResourceType {
    EC2_INSTANCE("EC2_INSTANCE"),
    EC2_NETWORK_INTERFACE("EC2_NETWORK_INTERFACE"),
    S3_BUCKET("S3_BUCKET"),
    S3_OBJECT("S3_OBJECT"),
    ACCESS_KEY("ACCESS_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingResourceType> VALUE_MAP;
    private final String value;

    private FindingResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingResourceType> knownValues() {
        EnumSet<FindingResourceType> knownValues = EnumSet.allOf(FindingResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingResourceType.class, FindingResourceType::toString);
    }
}

