/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ObjectDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ObjectDetail> {
    private static final SdkField<String> OBJECT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectArn").getter(S3ObjectDetail.getter(S3ObjectDetail::objectArn)).setter(S3ObjectDetail.setter(Builder::objectArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectArn").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Key").getter(S3ObjectDetail.getter(S3ObjectDetail::key)).setter(S3ObjectDetail.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(S3ObjectDetail.getter(S3ObjectDetail::eTag)).setter(S3ObjectDetail.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTag").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(S3ObjectDetail.getter(S3ObjectDetail::hash)).setter(S3ObjectDetail.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()}).build();
    private static final SdkField<String> VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionId").getter(S3ObjectDetail.getter(S3ObjectDetail::versionId)).setter(S3ObjectDetail.setter(Builder::versionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_ARN_FIELD, KEY_FIELD, E_TAG_FIELD, HASH_FIELD, VERSION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectArn;
    private final String key;
    private final String eTag;
    private final String hash;
    private final String versionId;

    private S3ObjectDetail(BuilderImpl builder) {
        this.objectArn = builder.objectArn;
        this.key = builder.key;
        this.eTag = builder.eTag;
        this.hash = builder.hash;
        this.versionId = builder.versionId;
    }

    public final String objectArn() {
        return this.objectArn;
    }

    public final String key() {
        return this.key;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String hash() {
        return this.hash;
    }

    public final String versionId() {
        return this.versionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectDetail)) {
            return false;
        }
        S3ObjectDetail other = (S3ObjectDetail)obj;
        return Objects.equals(this.objectArn(), other.objectArn()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.hash(), other.hash()) && Objects.equals(this.versionId(), other.versionId());
    }

    public final String toString() {
        return ToString.builder((String)"S3ObjectDetail").add("ObjectArn", (Object)this.objectArn()).add("Key", (Object)this.key()).add("ETag", (Object)this.eTag()).add("Hash", (Object)this.hash()).add("VersionId", (Object)this.versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectArn": {
                return Optional.ofNullable(clazz.cast(this.objectArn()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "VersionId": {
                return Optional.ofNullable(clazz.cast(this.versionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ObjectDetail, T> g) {
        return obj -> g.apply((S3ObjectDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectArn;
        private String key;
        private String eTag;
        private String hash;
        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ObjectDetail model) {
            this.objectArn(model.objectArn);
            this.key(model.key);
            this.eTag(model.eTag);
            this.hash(model.hash);
            this.versionId(model.versionId);
        }

        public final String getObjectArn() {
            return this.objectArn;
        }

        public final void setObjectArn(String objectArn) {
            this.objectArn = objectArn;
        }

        @Override
        public final Builder objectArn(String objectArn) {
            this.objectArn = objectArn;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final String getVersionId() {
            return this.versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public S3ObjectDetail build() {
            return new S3ObjectDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ObjectDetail> {
        public Builder objectArn(String var1);

        public Builder key(String var1);

        public Builder eTag(String var1);

        public Builder hash(String var1);

        public Builder versionId(String var1);
    }
}

