/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.guardduty.model.AffectedResourcesCopier;
import software.amazon.awssdk.services.guardduty.model.DomainDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteAccountDetails;
import software.amazon.awssdk.services.guardduty.model.RemoteIpDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsApiCallAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsApiCallAction> {
    private static final SdkField<String> API_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Api").getter(AwsApiCallAction.getter(AwsApiCallAction::api)).setter(AwsApiCallAction.setter(Builder::api)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("api").build()}).build();
    private static final SdkField<String> CALLER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CallerType").getter(AwsApiCallAction.getter(AwsApiCallAction::callerType)).setter(AwsApiCallAction.setter(Builder::callerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("callerType").build()}).build();
    private static final SdkField<DomainDetails> DOMAIN_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::domainDetails)).setter(AwsApiCallAction.setter(Builder::domainDetails)).constructor(DomainDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainDetails").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(AwsApiCallAction.getter(AwsApiCallAction::errorCode)).setter(AwsApiCallAction.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()}).build();
    private static final SdkField<String> USER_AGENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserAgent").getter(AwsApiCallAction.getter(AwsApiCallAction::userAgent)).setter(AwsApiCallAction.setter(Builder::userAgent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAgent").build()}).build();
    private static final SdkField<RemoteIpDetails> REMOTE_IP_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteIpDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::remoteIpDetails)).setter(AwsApiCallAction.setter(Builder::remoteIpDetails)).constructor(RemoteIpDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteIpDetails").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(AwsApiCallAction.getter(AwsApiCallAction::serviceName)).setter(AwsApiCallAction.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceName").build()}).build();
    private static final SdkField<RemoteAccountDetails> REMOTE_ACCOUNT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoteAccountDetails").getter(AwsApiCallAction.getter(AwsApiCallAction::remoteAccountDetails)).setter(AwsApiCallAction.setter(Builder::remoteAccountDetails)).constructor(RemoteAccountDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteAccountDetails").build()}).build();
    private static final SdkField<Map<String, String>> AFFECTED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AffectedResources").getter(AwsApiCallAction.getter(AwsApiCallAction::affectedResources)).setter(AwsApiCallAction.setter(Builder::affectedResources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("affectedResources").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_FIELD, CALLER_TYPE_FIELD, DOMAIN_DETAILS_FIELD, ERROR_CODE_FIELD, USER_AGENT_FIELD, REMOTE_IP_DETAILS_FIELD, SERVICE_NAME_FIELD, REMOTE_ACCOUNT_DETAILS_FIELD, AFFECTED_RESOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("api", API_FIELD);
            this.put("callerType", CALLER_TYPE_FIELD);
            this.put("domainDetails", DOMAIN_DETAILS_FIELD);
            this.put("errorCode", ERROR_CODE_FIELD);
            this.put("userAgent", USER_AGENT_FIELD);
            this.put("remoteIpDetails", REMOTE_IP_DETAILS_FIELD);
            this.put("serviceName", SERVICE_NAME_FIELD);
            this.put("remoteAccountDetails", REMOTE_ACCOUNT_DETAILS_FIELD);
            this.put("affectedResources", AFFECTED_RESOURCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String api;
    private final String callerType;
    private final DomainDetails domainDetails;
    private final String errorCode;
    private final String userAgent;
    private final RemoteIpDetails remoteIpDetails;
    private final String serviceName;
    private final RemoteAccountDetails remoteAccountDetails;
    private final Map<String, String> affectedResources;

    private AwsApiCallAction(BuilderImpl builder) {
        this.api = builder.api;
        this.callerType = builder.callerType;
        this.domainDetails = builder.domainDetails;
        this.errorCode = builder.errorCode;
        this.userAgent = builder.userAgent;
        this.remoteIpDetails = builder.remoteIpDetails;
        this.serviceName = builder.serviceName;
        this.remoteAccountDetails = builder.remoteAccountDetails;
        this.affectedResources = builder.affectedResources;
    }

    public final String api() {
        return this.api;
    }

    public final String callerType() {
        return this.callerType;
    }

    public final DomainDetails domainDetails() {
        return this.domainDetails;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final String userAgent() {
        return this.userAgent;
    }

    public final RemoteIpDetails remoteIpDetails() {
        return this.remoteIpDetails;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final RemoteAccountDetails remoteAccountDetails() {
        return this.remoteAccountDetails;
    }

    public final boolean hasAffectedResources() {
        return this.affectedResources != null && !(this.affectedResources instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> affectedResources() {
        return this.affectedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.api());
        hashCode = 31 * hashCode + Objects.hashCode(this.callerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAgent());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteIpDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteAccountDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAffectedResources() ? this.affectedResources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsApiCallAction)) {
            return false;
        }
        AwsApiCallAction other = (AwsApiCallAction)obj;
        return Objects.equals(this.api(), other.api()) && Objects.equals(this.callerType(), other.callerType()) && Objects.equals(this.domainDetails(), other.domainDetails()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.userAgent(), other.userAgent()) && Objects.equals(this.remoteIpDetails(), other.remoteIpDetails()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.remoteAccountDetails(), other.remoteAccountDetails()) && this.hasAffectedResources() == other.hasAffectedResources() && Objects.equals(this.affectedResources(), other.affectedResources());
    }

    public final String toString() {
        return ToString.builder((String)"AwsApiCallAction").add("Api", (Object)this.api()).add("CallerType", (Object)this.callerType()).add("DomainDetails", (Object)this.domainDetails()).add("ErrorCode", (Object)this.errorCode()).add("UserAgent", (Object)this.userAgent()).add("RemoteIpDetails", (Object)this.remoteIpDetails()).add("ServiceName", (Object)this.serviceName()).add("RemoteAccountDetails", (Object)this.remoteAccountDetails()).add("AffectedResources", this.hasAffectedResources() ? this.affectedResources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Api": {
                return Optional.ofNullable(clazz.cast(this.api()));
            }
            case "CallerType": {
                return Optional.ofNullable(clazz.cast(this.callerType()));
            }
            case "DomainDetails": {
                return Optional.ofNullable(clazz.cast(this.domainDetails()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "UserAgent": {
                return Optional.ofNullable(clazz.cast(this.userAgent()));
            }
            case "RemoteIpDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteIpDetails()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "RemoteAccountDetails": {
                return Optional.ofNullable(clazz.cast(this.remoteAccountDetails()));
            }
            case "AffectedResources": {
                return Optional.ofNullable(clazz.cast(this.affectedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsApiCallAction, T> g) {
        return obj -> g.apply((AwsApiCallAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String api;
        private String callerType;
        private DomainDetails domainDetails;
        private String errorCode;
        private String userAgent;
        private RemoteIpDetails remoteIpDetails;
        private String serviceName;
        private RemoteAccountDetails remoteAccountDetails;
        private Map<String, String> affectedResources = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsApiCallAction model) {
            this.api(model.api);
            this.callerType(model.callerType);
            this.domainDetails(model.domainDetails);
            this.errorCode(model.errorCode);
            this.userAgent(model.userAgent);
            this.remoteIpDetails(model.remoteIpDetails);
            this.serviceName(model.serviceName);
            this.remoteAccountDetails(model.remoteAccountDetails);
            this.affectedResources(model.affectedResources);
        }

        public final String getApi() {
            return this.api;
        }

        public final void setApi(String api) {
            this.api = api;
        }

        @Override
        public final Builder api(String api) {
            this.api = api;
            return this;
        }

        public final String getCallerType() {
            return this.callerType;
        }

        public final void setCallerType(String callerType) {
            this.callerType = callerType;
        }

        @Override
        public final Builder callerType(String callerType) {
            this.callerType = callerType;
            return this;
        }

        public final DomainDetails.Builder getDomainDetails() {
            return this.domainDetails != null ? this.domainDetails.toBuilder() : null;
        }

        public final void setDomainDetails(DomainDetails.BuilderImpl domainDetails) {
            this.domainDetails = domainDetails != null ? domainDetails.build() : null;
        }

        @Override
        public final Builder domainDetails(DomainDetails domainDetails) {
            this.domainDetails = domainDetails;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getUserAgent() {
            return this.userAgent;
        }

        public final void setUserAgent(String userAgent) {
            this.userAgent = userAgent;
        }

        @Override
        public final Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public final RemoteIpDetails.Builder getRemoteIpDetails() {
            return this.remoteIpDetails != null ? this.remoteIpDetails.toBuilder() : null;
        }

        public final void setRemoteIpDetails(RemoteIpDetails.BuilderImpl remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails != null ? remoteIpDetails.build() : null;
        }

        @Override
        public final Builder remoteIpDetails(RemoteIpDetails remoteIpDetails) {
            this.remoteIpDetails = remoteIpDetails;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final RemoteAccountDetails.Builder getRemoteAccountDetails() {
            return this.remoteAccountDetails != null ? this.remoteAccountDetails.toBuilder() : null;
        }

        public final void setRemoteAccountDetails(RemoteAccountDetails.BuilderImpl remoteAccountDetails) {
            this.remoteAccountDetails = remoteAccountDetails != null ? remoteAccountDetails.build() : null;
        }

        @Override
        public final Builder remoteAccountDetails(RemoteAccountDetails remoteAccountDetails) {
            this.remoteAccountDetails = remoteAccountDetails;
            return this;
        }

        public final Map<String, String> getAffectedResources() {
            if (this.affectedResources instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.affectedResources;
        }

        public final void setAffectedResources(Map<String, String> affectedResources) {
            this.affectedResources = AffectedResourcesCopier.copy(affectedResources);
        }

        @Override
        public final Builder affectedResources(Map<String, String> affectedResources) {
            this.affectedResources = AffectedResourcesCopier.copy(affectedResources);
            return this;
        }

        public AwsApiCallAction build() {
            return new AwsApiCallAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsApiCallAction> {
        public Builder api(String var1);

        public Builder callerType(String var1);

        public Builder domainDetails(DomainDetails var1);

        default public Builder domainDetails(Consumer<DomainDetails.Builder> domainDetails) {
            return this.domainDetails((DomainDetails)((DomainDetails.Builder)DomainDetails.builder().applyMutation(domainDetails)).build());
        }

        public Builder errorCode(String var1);

        public Builder userAgent(String var1);

        public Builder remoteIpDetails(RemoteIpDetails var1);

        default public Builder remoteIpDetails(Consumer<RemoteIpDetails.Builder> remoteIpDetails) {
            return this.remoteIpDetails((RemoteIpDetails)((RemoteIpDetails.Builder)RemoteIpDetails.builder().applyMutation(remoteIpDetails)).build());
        }

        public Builder serviceName(String var1);

        public Builder remoteAccountDetails(RemoteAccountDetails var1);

        default public Builder remoteAccountDetails(Consumer<RemoteAccountDetails.Builder> remoteAccountDetails) {
            return this.remoteAccountDetails((RemoteAccountDetails)((RemoteAccountDetails.Builder)RemoteAccountDetails.builder().applyMutation(remoteAccountDetails)).build());
        }

        public Builder affectedResources(Map<String, String> var1);
    }
}

