/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.internal.UserAgentUtils;
import software.amazon.awssdk.services.guardduty.model.CoverageResource;
import software.amazon.awssdk.services.guardduty.model.ListCoverageRequest;
import software.amazon.awssdk.services.guardduty.model.ListCoverageResponse;

public class ListCoverageIterable
implements SdkIterable<ListCoverageResponse> {
    private final GuardDutyClient client;
    private final ListCoverageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoverageIterable(GuardDutyClient client, ListCoverageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoverageResponseFetcher();
    }

    public Iterator<ListCoverageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoverageResource> resources() {
        Function<ListCoverageResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoverageResponseFetcher
    implements SyncPageFetcher<ListCoverageResponse> {
        private ListCoverageResponseFetcher() {
        }

        public boolean hasNextPage(ListCoverageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoverageResponse nextPage(ListCoverageResponse previousPage) {
            if (previousPage == null) {
                return ListCoverageIterable.this.client.listCoverage(ListCoverageIterable.this.firstRequest);
            }
            return ListCoverageIterable.this.client.listCoverage((ListCoverageRequest)((Object)ListCoverageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

