/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageFeature {
    FLOW_LOGS("FLOW_LOGS"),
    CLOUD_TRAIL("CLOUD_TRAIL"),
    DNS_LOGS("DNS_LOGS"),
    S3_DATA_EVENTS("S3_DATA_EVENTS"),
    EKS_AUDIT_LOGS("EKS_AUDIT_LOGS"),
    EBS_MALWARE_PROTECTION("EBS_MALWARE_PROTECTION"),
    RDS_LOGIN_EVENTS("RDS_LOGIN_EVENTS"),
    LAMBDA_NETWORK_LOGS("LAMBDA_NETWORK_LOGS"),
    EKS_RUNTIME_MONITORING("EKS_RUNTIME_MONITORING"),
    FARGATE_RUNTIME_MONITORING("FARGATE_RUNTIME_MONITORING"),
    EC2_RUNTIME_MONITORING("EC2_RUNTIME_MONITORING"),
    RDS_DBI_PROTECTION_PROVISIONED("RDS_DBI_PROTECTION_PROVISIONED"),
    RDS_DBI_PROTECTION_SERVERLESS("RDS_DBI_PROTECTION_SERVERLESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageFeature> VALUE_MAP;
    private final String value;

    private UsageFeature(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageFeature fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageFeature> knownValues() {
        EnumSet<UsageFeature> knownValues = EnumSet.allOf(UsageFeature.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageFeature.class, UsageFeature::toString);
    }
}

