/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.IssuesCopier;
import software.amazon.awssdk.services.guardduty.model.ManagementType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FargateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FargateDetails> {
    private static final SdkField<List<String>> ISSUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Issues").getter(FargateDetails.getter(FargateDetails::issues)).setter(FargateDetails.setter(Builder::issues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagementType").getter(FargateDetails.getter(FargateDetails::managementTypeAsString)).setter(FargateDetails.setter(Builder::managementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managementType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUES_FIELD, MANAGEMENT_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> issues;
    private final String managementType;

    private FargateDetails(BuilderImpl builder) {
        this.issues = builder.issues;
        this.managementType = builder.managementType;
    }

    public final boolean hasIssues() {
        return this.issues != null && !(this.issues instanceof SdkAutoConstructList);
    }

    public final List<String> issues() {
        return this.issues;
    }

    public final ManagementType managementType() {
        return ManagementType.fromValue(this.managementType);
    }

    public final String managementTypeAsString() {
        return this.managementType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIssues() ? this.issues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managementTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FargateDetails)) {
            return false;
        }
        FargateDetails other = (FargateDetails)obj;
        return this.hasIssues() == other.hasIssues() && Objects.equals(this.issues(), other.issues()) && Objects.equals(this.managementTypeAsString(), other.managementTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FargateDetails").add("Issues", this.hasIssues() ? this.issues() : null).add("ManagementType", (Object)this.managementTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Issues": {
                return Optional.ofNullable(clazz.cast(this.issues()));
            }
            case "ManagementType": {
                return Optional.ofNullable(clazz.cast(this.managementTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FargateDetails, T> g) {
        return obj -> g.apply((FargateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> issues = DefaultSdkAutoConstructList.getInstance();
        private String managementType;

        private BuilderImpl() {
        }

        private BuilderImpl(FargateDetails model) {
            this.issues(model.issues);
            this.managementType(model.managementType);
        }

        public final Collection<String> getIssues() {
            if (this.issues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.issues;
        }

        public final void setIssues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
        }

        @Override
        public final Builder issues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(String ... issues) {
            this.issues(Arrays.asList(issues));
            return this;
        }

        public final String getManagementType() {
            return this.managementType;
        }

        public final void setManagementType(String managementType) {
            this.managementType = managementType;
        }

        @Override
        public final Builder managementType(String managementType) {
            this.managementType = managementType;
            return this;
        }

        @Override
        public final Builder managementType(ManagementType managementType) {
            this.managementType(managementType == null ? null : managementType.toString());
            return this;
        }

        public FargateDetails build() {
            return new FargateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FargateDetails> {
        public Builder issues(Collection<String> var1);

        public Builder issues(String ... var1);

        public Builder managementType(String var1);

        public Builder managementType(ManagementType var1);
    }
}

