/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum UsageStatisticType {
    SUM_BY_ACCOUNT("SUM_BY_ACCOUNT"),
    SUM_BY_DATA_SOURCE("SUM_BY_DATA_SOURCE"),
    SUM_BY_RESOURCE("SUM_BY_RESOURCE"),
    TOP_RESOURCES("TOP_RESOURCES"),
    SUM_BY_FEATURES("SUM_BY_FEATURES"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, UsageStatisticType> VALUE_MAP;
    private final String value;

    private UsageStatisticType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static UsageStatisticType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<UsageStatisticType> knownValues() {
        EnumSet<UsageStatisticType> knownValues = EnumSet.allOf(UsageStatisticType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(UsageStatisticType.class, UsageStatisticType::toString);
    }
}

