/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.CloudTrailConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.DNSLogsConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.FlowLogsConfigurationResult;
import software.amazon.awssdk.services.guardduty.model.S3LogsConfigurationResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfigurationsResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfigurationsResult> {
    private static final SdkField<CloudTrailConfigurationResult> CLOUD_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudTrail").getter(DataSourceConfigurationsResult.getter(DataSourceConfigurationsResult::cloudTrail)).setter(DataSourceConfigurationsResult.setter(Builder::cloudTrail)).constructor(CloudTrailConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrail").build()}).build();
    private static final SdkField<DNSLogsConfigurationResult> DNS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DNSLogs").getter(DataSourceConfigurationsResult.getter(DataSourceConfigurationsResult::dnsLogs)).setter(DataSourceConfigurationsResult.setter(Builder::dnsLogs)).constructor(DNSLogsConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsLogs").build()}).build();
    private static final SdkField<FlowLogsConfigurationResult> FLOW_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowLogs").getter(DataSourceConfigurationsResult.getter(DataSourceConfigurationsResult::flowLogs)).setter(DataSourceConfigurationsResult.setter(Builder::flowLogs)).constructor(FlowLogsConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowLogs").build()}).build();
    private static final SdkField<S3LogsConfigurationResult> S3_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Logs").getter(DataSourceConfigurationsResult.getter(DataSourceConfigurationsResult::s3Logs)).setter(DataSourceConfigurationsResult.setter(Builder::s3Logs)).constructor(S3LogsConfigurationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_FIELD, DNS_LOGS_FIELD, FLOW_LOGS_FIELD, S3_LOGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final CloudTrailConfigurationResult cloudTrail;
    private final DNSLogsConfigurationResult dnsLogs;
    private final FlowLogsConfigurationResult flowLogs;
    private final S3LogsConfigurationResult s3Logs;

    private DataSourceConfigurationsResult(BuilderImpl builder) {
        this.cloudTrail = builder.cloudTrail;
        this.dnsLogs = builder.dnsLogs;
        this.flowLogs = builder.flowLogs;
        this.s3Logs = builder.s3Logs;
    }

    public final CloudTrailConfigurationResult cloudTrail() {
        return this.cloudTrail;
    }

    public final DNSLogsConfigurationResult dnsLogs() {
        return this.dnsLogs;
    }

    public final FlowLogsConfigurationResult flowLogs() {
        return this.flowLogs;
    }

    public final S3LogsConfigurationResult s3Logs() {
        return this.s3Logs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrail());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Logs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfigurationsResult)) {
            return false;
        }
        DataSourceConfigurationsResult other = (DataSourceConfigurationsResult)obj;
        return Objects.equals(this.cloudTrail(), other.cloudTrail()) && Objects.equals(this.dnsLogs(), other.dnsLogs()) && Objects.equals(this.flowLogs(), other.flowLogs()) && Objects.equals(this.s3Logs(), other.s3Logs());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfigurationsResult").add("CloudTrail", (Object)this.cloudTrail()).add("DNSLogs", (Object)this.dnsLogs()).add("FlowLogs", (Object)this.flowLogs()).add("S3Logs", (Object)this.s3Logs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudTrail": {
                return Optional.ofNullable(clazz.cast(this.cloudTrail()));
            }
            case "DNSLogs": {
                return Optional.ofNullable(clazz.cast(this.dnsLogs()));
            }
            case "FlowLogs": {
                return Optional.ofNullable(clazz.cast(this.flowLogs()));
            }
            case "S3Logs": {
                return Optional.ofNullable(clazz.cast(this.s3Logs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfigurationsResult, T> g) {
        return obj -> g.apply((DataSourceConfigurationsResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CloudTrailConfigurationResult cloudTrail;
        private DNSLogsConfigurationResult dnsLogs;
        private FlowLogsConfigurationResult flowLogs;
        private S3LogsConfigurationResult s3Logs;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfigurationsResult model) {
            this.cloudTrail(model.cloudTrail);
            this.dnsLogs(model.dnsLogs);
            this.flowLogs(model.flowLogs);
            this.s3Logs(model.s3Logs);
        }

        public final CloudTrailConfigurationResult.Builder getCloudTrail() {
            return this.cloudTrail != null ? this.cloudTrail.toBuilder() : null;
        }

        @Override
        public final Builder cloudTrail(CloudTrailConfigurationResult cloudTrail) {
            this.cloudTrail = cloudTrail;
            return this;
        }

        public final void setCloudTrail(CloudTrailConfigurationResult.BuilderImpl cloudTrail) {
            this.cloudTrail = cloudTrail != null ? cloudTrail.build() : null;
        }

        public final DNSLogsConfigurationResult.Builder getDnsLogs() {
            return this.dnsLogs != null ? this.dnsLogs.toBuilder() : null;
        }

        @Override
        public final Builder dnsLogs(DNSLogsConfigurationResult dnsLogs) {
            this.dnsLogs = dnsLogs;
            return this;
        }

        public final void setDnsLogs(DNSLogsConfigurationResult.BuilderImpl dnsLogs) {
            this.dnsLogs = dnsLogs != null ? dnsLogs.build() : null;
        }

        public final FlowLogsConfigurationResult.Builder getFlowLogs() {
            return this.flowLogs != null ? this.flowLogs.toBuilder() : null;
        }

        @Override
        public final Builder flowLogs(FlowLogsConfigurationResult flowLogs) {
            this.flowLogs = flowLogs;
            return this;
        }

        public final void setFlowLogs(FlowLogsConfigurationResult.BuilderImpl flowLogs) {
            this.flowLogs = flowLogs != null ? flowLogs.build() : null;
        }

        public final S3LogsConfigurationResult.Builder getS3Logs() {
            return this.s3Logs != null ? this.s3Logs.toBuilder() : null;
        }

        @Override
        public final Builder s3Logs(S3LogsConfigurationResult s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final void setS3Logs(S3LogsConfigurationResult.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        public DataSourceConfigurationsResult build() {
            return new DataSourceConfigurationsResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfigurationsResult> {
        public Builder cloudTrail(CloudTrailConfigurationResult var1);

        default public Builder cloudTrail(Consumer<CloudTrailConfigurationResult.Builder> cloudTrail) {
            return this.cloudTrail((CloudTrailConfigurationResult)((CloudTrailConfigurationResult.Builder)CloudTrailConfigurationResult.builder().applyMutation(cloudTrail)).build());
        }

        public Builder dnsLogs(DNSLogsConfigurationResult var1);

        default public Builder dnsLogs(Consumer<DNSLogsConfigurationResult.Builder> dnsLogs) {
            return this.dnsLogs((DNSLogsConfigurationResult)((DNSLogsConfigurationResult.Builder)DNSLogsConfigurationResult.builder().applyMutation(dnsLogs)).build());
        }

        public Builder flowLogs(FlowLogsConfigurationResult var1);

        default public Builder flowLogs(Consumer<FlowLogsConfigurationResult.Builder> flowLogs) {
            return this.flowLogs((FlowLogsConfigurationResult)((FlowLogsConfigurationResult.Builder)FlowLogsConfigurationResult.builder().applyMutation(flowLogs)).build());
        }

        public Builder s3Logs(S3LogsConfigurationResult var1);

        default public Builder s3Logs(Consumer<S3LogsConfigurationResult.Builder> s3Logs) {
            return this.s3Logs((S3LogsConfigurationResult)((S3LogsConfigurationResult.Builder)S3LogsConfigurationResult.builder().applyMutation(s3Logs)).build());
        }
    }
}

