/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DestinationProperties;
import software.amazon.awssdk.services.guardduty.model.DestinationType;
import software.amazon.awssdk.services.guardduty.model.GuardDutyResponse;
import software.amazon.awssdk.services.guardduty.model.PublishingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribePublishingDestinationResponse
extends GuardDutyResponse
implements ToCopyableBuilder<Builder, DescribePublishingDestinationResponse> {
    private static final SdkField<String> DESTINATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationId").getter(DescribePublishingDestinationResponse.getter(DescribePublishingDestinationResponse::destinationId)).setter(DescribePublishingDestinationResponse.setter(Builder::destinationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationId").build()}).build();
    private static final SdkField<String> DESTINATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationType").getter(DescribePublishingDestinationResponse.getter(DescribePublishingDestinationResponse::destinationTypeAsString)).setter(DescribePublishingDestinationResponse.setter(Builder::destinationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribePublishingDestinationResponse.getter(DescribePublishingDestinationResponse::statusAsString)).setter(DescribePublishingDestinationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Long> PUBLISHING_FAILURE_START_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("PublishingFailureStartTimestamp").getter(DescribePublishingDestinationResponse.getter(DescribePublishingDestinationResponse::publishingFailureStartTimestamp)).setter(DescribePublishingDestinationResponse.setter(Builder::publishingFailureStartTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishingFailureStartTimestamp").build()}).build();
    private static final SdkField<DestinationProperties> DESTINATION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationProperties").getter(DescribePublishingDestinationResponse.getter(DescribePublishingDestinationResponse::destinationProperties)).setter(DescribePublishingDestinationResponse.setter(Builder::destinationProperties)).constructor(DestinationProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_ID_FIELD, DESTINATION_TYPE_FIELD, STATUS_FIELD, PUBLISHING_FAILURE_START_TIMESTAMP_FIELD, DESTINATION_PROPERTIES_FIELD));
    private final String destinationId;
    private final String destinationType;
    private final String status;
    private final Long publishingFailureStartTimestamp;
    private final DestinationProperties destinationProperties;

    private DescribePublishingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.destinationId = builder.destinationId;
        this.destinationType = builder.destinationType;
        this.status = builder.status;
        this.publishingFailureStartTimestamp = builder.publishingFailureStartTimestamp;
        this.destinationProperties = builder.destinationProperties;
    }

    public final String destinationId() {
        return this.destinationId;
    }

    public final DestinationType destinationType() {
        return DestinationType.fromValue(this.destinationType);
    }

    public final String destinationTypeAsString() {
        return this.destinationType;
    }

    public final PublishingStatus status() {
        return PublishingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long publishingFailureStartTimestamp() {
        return this.publishingFailureStartTimestamp;
    }

    public final DestinationProperties destinationProperties() {
        return this.destinationProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishingFailureStartTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePublishingDestinationResponse)) {
            return false;
        }
        DescribePublishingDestinationResponse other = (DescribePublishingDestinationResponse)((Object)obj);
        return Objects.equals(this.destinationId(), other.destinationId()) && Objects.equals(this.destinationTypeAsString(), other.destinationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.publishingFailureStartTimestamp(), other.publishingFailureStartTimestamp()) && Objects.equals(this.destinationProperties(), other.destinationProperties());
    }

    public final String toString() {
        return ToString.builder((String)"DescribePublishingDestinationResponse").add("DestinationId", (Object)this.destinationId()).add("DestinationType", (Object)this.destinationTypeAsString()).add("Status", (Object)this.statusAsString()).add("PublishingFailureStartTimestamp", (Object)this.publishingFailureStartTimestamp()).add("DestinationProperties", (Object)this.destinationProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationId": {
                return Optional.ofNullable(clazz.cast(this.destinationId()));
            }
            case "DestinationType": {
                return Optional.ofNullable(clazz.cast(this.destinationTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "PublishingFailureStartTimestamp": {
                return Optional.ofNullable(clazz.cast(this.publishingFailureStartTimestamp()));
            }
            case "DestinationProperties": {
                return Optional.ofNullable(clazz.cast(this.destinationProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePublishingDestinationResponse, T> g) {
        return obj -> g.apply((DescribePublishingDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyResponse.BuilderImpl
    implements Builder {
        private String destinationId;
        private String destinationType;
        private String status;
        private Long publishingFailureStartTimestamp;
        private DestinationProperties destinationProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePublishingDestinationResponse model) {
            super(model);
            this.destinationId(model.destinationId);
            this.destinationType(model.destinationType);
            this.status(model.status);
            this.publishingFailureStartTimestamp(model.publishingFailureStartTimestamp);
            this.destinationProperties(model.destinationProperties);
        }

        public final String getDestinationId() {
            return this.destinationId;
        }

        @Override
        public final Builder destinationId(String destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        public final void setDestinationId(String destinationId) {
            this.destinationId = destinationId;
        }

        public final String getDestinationType() {
            return this.destinationType;
        }

        @Override
        public final Builder destinationType(String destinationType) {
            this.destinationType = destinationType;
            return this;
        }

        @Override
        public final Builder destinationType(DestinationType destinationType) {
            this.destinationType(destinationType == null ? null : destinationType.toString());
            return this;
        }

        public final void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PublishingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getPublishingFailureStartTimestamp() {
            return this.publishingFailureStartTimestamp;
        }

        @Override
        public final Builder publishingFailureStartTimestamp(Long publishingFailureStartTimestamp) {
            this.publishingFailureStartTimestamp = publishingFailureStartTimestamp;
            return this;
        }

        public final void setPublishingFailureStartTimestamp(Long publishingFailureStartTimestamp) {
            this.publishingFailureStartTimestamp = publishingFailureStartTimestamp;
        }

        public final DestinationProperties.Builder getDestinationProperties() {
            return this.destinationProperties != null ? this.destinationProperties.toBuilder() : null;
        }

        @Override
        public final Builder destinationProperties(DestinationProperties destinationProperties) {
            this.destinationProperties = destinationProperties;
            return this;
        }

        public final void setDestinationProperties(DestinationProperties.BuilderImpl destinationProperties) {
            this.destinationProperties = destinationProperties != null ? destinationProperties.build() : null;
        }

        @Override
        public DescribePublishingDestinationResponse build() {
            return new DescribePublishingDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribePublishingDestinationResponse> {
        public Builder destinationId(String var1);

        public Builder destinationType(String var1);

        public Builder destinationType(DestinationType var1);

        public Builder status(String var1);

        public Builder status(PublishingStatus var1);

        public Builder publishingFailureStartTimestamp(Long var1);

        public Builder destinationProperties(DestinationProperties var1);

        default public Builder destinationProperties(Consumer<DestinationProperties.Builder> destinationProperties) {
            return this.destinationProperties((DestinationProperties)((DestinationProperties.Builder)DestinationProperties.builder().applyMutation(destinationProperties)).build());
        }
    }
}

