/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.DefaultServerSideEncryption;
import software.amazon.awssdk.services.guardduty.model.Owner;
import software.amazon.awssdk.services.guardduty.model.PublicAccess;
import software.amazon.awssdk.services.guardduty.model.Tag;
import software.amazon.awssdk.services.guardduty.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3BucketDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3BucketDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(S3BucketDetail.getter(S3BucketDetail::arn)).setter(S3BucketDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(S3BucketDetail.getter(S3BucketDetail::name)).setter(S3BucketDetail.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(S3BucketDetail.getter(S3BucketDetail::type)).setter(S3BucketDetail.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(S3BucketDetail.getter(S3BucketDetail::createdAt)).setter(S3BucketDetail.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Owner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Owner").getter(S3BucketDetail.getter(S3BucketDetail::owner)).setter(S3BucketDetail.setter(Builder::owner)).constructor(Owner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(S3BucketDetail.getter(S3BucketDetail::tags)).setter(S3BucketDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DefaultServerSideEncryption> DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultServerSideEncryption").getter(S3BucketDetail.getter(S3BucketDetail::defaultServerSideEncryption)).setter(S3BucketDetail.setter(Builder::defaultServerSideEncryption)).constructor(DefaultServerSideEncryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultServerSideEncryption").build()}).build();
    private static final SdkField<PublicAccess> PUBLIC_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PublicAccess").getter(S3BucketDetail.getter(S3BucketDetail::publicAccess)).setter(S3BucketDetail.setter(Builder::publicAccess)).constructor(PublicAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, CREATED_AT_FIELD, OWNER_FIELD, TAGS_FIELD, DEFAULT_SERVER_SIDE_ENCRYPTION_FIELD, PUBLIC_ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final Instant createdAt;
    private final Owner owner;
    private final List<Tag> tags;
    private final DefaultServerSideEncryption defaultServerSideEncryption;
    private final PublicAccess publicAccess;

    private S3BucketDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.owner = builder.owner;
        this.tags = builder.tags;
        this.defaultServerSideEncryption = builder.defaultServerSideEncryption;
        this.publicAccess = builder.publicAccess;
    }

    public String arn() {
        return this.arn;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public Owner owner() {
        return this.owner;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public DefaultServerSideEncryption defaultServerSideEncryption() {
        return this.defaultServerSideEncryption;
    }

    public PublicAccess publicAccess() {
        return this.publicAccess;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultServerSideEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicAccess());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3BucketDetail)) {
            return false;
        }
        S3BucketDetail other = (S3BucketDetail)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.defaultServerSideEncryption(), other.defaultServerSideEncryption()) && Objects.equals(this.publicAccess(), other.publicAccess());
    }

    public String toString() {
        return ToString.builder((String)"S3BucketDetail").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.type()).add("CreatedAt", (Object)this.createdAt()).add("Owner", (Object)this.owner()).add("Tags", this.tags()).add("DefaultServerSideEncryption", (Object)this.defaultServerSideEncryption()).add("PublicAccess", (Object)this.publicAccess()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DefaultServerSideEncryption": {
                return Optional.ofNullable(clazz.cast(this.defaultServerSideEncryption()));
            }
            case "PublicAccess": {
                return Optional.ofNullable(clazz.cast(this.publicAccess()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3BucketDetail, T> g) {
        return obj -> g.apply((S3BucketDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private Instant createdAt;
        private Owner owner;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private DefaultServerSideEncryption defaultServerSideEncryption;
        private PublicAccess publicAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(S3BucketDetail model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.createdAt(model.createdAt);
            this.owner(model.owner);
            this.tags(model.tags);
            this.defaultServerSideEncryption(model.defaultServerSideEncryption);
            this.publicAccess(model.publicAccess);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Owner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(Owner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final DefaultServerSideEncryption.Builder getDefaultServerSideEncryption() {
            return this.defaultServerSideEncryption != null ? this.defaultServerSideEncryption.toBuilder() : null;
        }

        @Override
        public final Builder defaultServerSideEncryption(DefaultServerSideEncryption defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption;
            return this;
        }

        public final void setDefaultServerSideEncryption(DefaultServerSideEncryption.BuilderImpl defaultServerSideEncryption) {
            this.defaultServerSideEncryption = defaultServerSideEncryption != null ? defaultServerSideEncryption.build() : null;
        }

        public final PublicAccess.Builder getPublicAccess() {
            return this.publicAccess != null ? this.publicAccess.toBuilder() : null;
        }

        @Override
        public final Builder publicAccess(PublicAccess publicAccess) {
            this.publicAccess = publicAccess;
            return this;
        }

        public final void setPublicAccess(PublicAccess.BuilderImpl publicAccess) {
            this.publicAccess = publicAccess != null ? publicAccess.build() : null;
        }

        public S3BucketDetail build() {
            return new S3BucketDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3BucketDetail> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder createdAt(Instant var1);

        public Builder owner(Owner var1);

        default public Builder owner(Consumer<Owner.Builder> owner) {
            return this.owner((Owner)((Owner.Builder)Owner.builder().applyMutation(owner)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder defaultServerSideEncryption(DefaultServerSideEncryption var1);

        default public Builder defaultServerSideEncryption(Consumer<DefaultServerSideEncryption.Builder> defaultServerSideEncryption) {
            return this.defaultServerSideEncryption((DefaultServerSideEncryption)((DefaultServerSideEncryption.Builder)DefaultServerSideEncryption.builder().applyMutation(defaultServerSideEncryption)).build());
        }

        public Builder publicAccess(PublicAccess var1);

        default public Builder publicAccess(Consumer<PublicAccess.Builder> publicAccess) {
            return this.publicAccess((PublicAccess)((PublicAccess.Builder)PublicAccess.builder().applyMutation(publicAccess)).build());
        }
    }
}

