/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DataSource;
import software.amazon.awssdk.services.guardduty.model.Total;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UsageDataSourceResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UsageDataSourceResult> {
    private static final SdkField<String> DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UsageDataSourceResult.getter(UsageDataSourceResult::dataSourceAsString)).setter(UsageDataSourceResult.setter(Builder::dataSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSource").build()}).build();
    private static final SdkField<Total> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UsageDataSourceResult.getter(UsageDataSourceResult::total)).setter(UsageDataSourceResult.setter(Builder::total)).constructor(Total::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_FIELD, TOTAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSource;
    private final Total total;

    private UsageDataSourceResult(BuilderImpl builder) {
        this.dataSource = builder.dataSource;
        this.total = builder.total;
    }

    public DataSource dataSource() {
        return DataSource.fromValue(this.dataSource);
    }

    public String dataSourceAsString() {
        return this.dataSource;
    }

    public Total total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageDataSourceResult)) {
            return false;
        }
        UsageDataSourceResult other = (UsageDataSourceResult)obj;
        return Objects.equals(this.dataSourceAsString(), other.dataSourceAsString()) && Objects.equals(this.total(), other.total());
    }

    public String toString() {
        return ToString.builder((String)"UsageDataSourceResult").add("DataSource", (Object)this.dataSourceAsString()).add("Total", (Object)this.total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSource": {
                return Optional.ofNullable(clazz.cast(this.dataSourceAsString()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UsageDataSourceResult, T> g) {
        return obj -> g.apply((UsageDataSourceResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSource;
        private Total total;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageDataSourceResult model) {
            this.dataSource(model.dataSource);
            this.total(model.total);
        }

        public final String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final Builder dataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        @Override
        public final Builder dataSource(DataSource dataSource) {
            this.dataSource(dataSource == null ? null : dataSource.toString());
            return this;
        }

        public final void setDataSource(String dataSource) {
            this.dataSource = dataSource;
        }

        public final Total.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(Total total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Total.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public UsageDataSourceResult build() {
            return new UsageDataSourceResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UsageDataSourceResult> {
        public Builder dataSource(String var1);

        public Builder dataSource(DataSource var1);

        public Builder total(Total var1);

        default public Builder total(Consumer<Total.Builder> total) {
            return this.total((Total)((Total.Builder)Total.builder().applyMutation(total)).build());
        }
    }
}

