/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.IpSetFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIpSetRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, CreateIpSetRequest> {
    private static final SdkField<Boolean> ACTIVATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateIpSetRequest.getter(CreateIpSetRequest::activate)).setter(CreateIpSetRequest.setter(Builder::activate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activate").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateIpSetRequest.getter(CreateIpSetRequest::clientToken)).setter(CreateIpSetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateIpSetRequest.getter(CreateIpSetRequest::detectorId)).setter(CreateIpSetRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateIpSetRequest.getter(CreateIpSetRequest::formatAsString)).setter(CreateIpSetRequest.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateIpSetRequest.getter(CreateIpSetRequest::location)).setter(CreateIpSetRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateIpSetRequest.getter(CreateIpSetRequest::name)).setter(CreateIpSetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATE_FIELD, CLIENT_TOKEN_FIELD, DETECTOR_ID_FIELD, FORMAT_FIELD, LOCATION_FIELD, NAME_FIELD));
    private final Boolean activate;
    private final String clientToken;
    private final String detectorId;
    private final String format;
    private final String location;
    private final String name;

    private CreateIpSetRequest(BuilderImpl builder) {
        super(builder);
        this.activate = builder.activate;
        this.clientToken = builder.clientToken;
        this.detectorId = builder.detectorId;
        this.format = builder.format;
        this.location = builder.location;
        this.name = builder.name;
    }

    public Boolean activate() {
        return this.activate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String detectorId() {
        return this.detectorId;
    }

    public IpSetFormat format() {
        return IpSetFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public String location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activate());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpSetRequest)) {
            return false;
        }
        CreateIpSetRequest other = (CreateIpSetRequest)((Object)obj);
        return Objects.equals(this.activate(), other.activate()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.name(), other.name());
    }

    public String toString() {
        return ToString.builder((String)"CreateIpSetRequest").add("Activate", (Object)this.activate()).add("ClientToken", (Object)this.clientToken()).add("DetectorId", (Object)this.detectorId()).add("Format", (Object)this.formatAsString()).add("Location", (Object)this.location()).add("Name", (Object)this.name()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Activate": {
                return Optional.ofNullable(clazz.cast(this.activate()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIpSetRequest, T> g) {
        return obj -> g.apply((CreateIpSetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private Boolean activate;
        private String clientToken;
        private String detectorId;
        private String format;
        private String location;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpSetRequest model) {
            super(model);
            this.activate(model.activate);
            this.clientToken(model.clientToken);
            this.detectorId(model.detectorId);
            this.format(model.format);
            this.location(model.location);
            this.name(model.name);
        }

        public final Boolean getActivate() {
            return this.activate;
        }

        @Override
        public final Builder activate(Boolean activate) {
            this.activate = activate;
            return this;
        }

        public final void setActivate(Boolean activate) {
            this.activate = activate;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(IpSetFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpSetRequest build() {
            return new CreateIpSetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIpSetRequest> {
        public Builder activate(Boolean var1);

        public Builder clientToken(String var1);

        public Builder detectorId(String var1);

        public Builder format(String var1);

        public Builder format(IpSetFormat var1);

        public Builder location(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

