/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.guardduty.GuardDutyClient;
import software.amazon.awssdk.services.guardduty.model.ListFiltersRequest;
import software.amazon.awssdk.services.guardduty.model.ListFiltersResponse;

public class ListFiltersIterable
implements SdkIterable<ListFiltersResponse> {
    private final GuardDutyClient client;
    private final ListFiltersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFiltersIterable(GuardDutyClient client, ListFiltersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFiltersResponseFetcher();
    }

    public Iterator<ListFiltersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> filterNames() {
        Function<ListFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.filterNames() != null) {
                return response.filterNames().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListFiltersIterable resume(ListFiltersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListFiltersIterable(this.client, (ListFiltersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListFiltersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListFiltersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListFiltersResponseFetcher
    implements SyncPageFetcher<ListFiltersResponse> {
        private ListFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFiltersResponse nextPage(ListFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFiltersIterable.this.client.listFilters(ListFiltersIterable.this.firstRequest);
            }
            return ListFiltersIterable.this.client.listFilters((ListFiltersRequest)((Object)ListFiltersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

