/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Organization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Organization> {
    private static final SdkField<String> ASN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::asn)).setter(Organization.setter(Builder::asn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asn").build()}).build();
    private static final SdkField<String> ASN_ORG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::asnOrg)).setter(Organization.setter(Builder::asnOrg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asnOrg").build()}).build();
    private static final SdkField<String> ISP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::isp)).setter(Organization.setter(Builder::isp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isp").build()}).build();
    private static final SdkField<String> ORG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Organization.getter(Organization::org)).setter(Organization.setter(Builder::org)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("org").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASN_FIELD, ASN_ORG_FIELD, ISP_FIELD, ORG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String asn;
    private final String asnOrg;
    private final String isp;
    private final String org;

    private Organization(BuilderImpl builder) {
        this.asn = builder.asn;
        this.asnOrg = builder.asnOrg;
        this.isp = builder.isp;
        this.org = builder.org;
    }

    public String asn() {
        return this.asn;
    }

    public String asnOrg() {
        return this.asnOrg;
    }

    public String isp() {
        return this.isp;
    }

    public String org() {
        return this.org;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.asn());
        hashCode = 31 * hashCode + Objects.hashCode(this.asnOrg());
        hashCode = 31 * hashCode + Objects.hashCode(this.isp());
        hashCode = 31 * hashCode + Objects.hashCode(this.org());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Organization)) {
            return false;
        }
        Organization other = (Organization)obj;
        return Objects.equals(this.asn(), other.asn()) && Objects.equals(this.asnOrg(), other.asnOrg()) && Objects.equals(this.isp(), other.isp()) && Objects.equals(this.org(), other.org());
    }

    public String toString() {
        return ToString.builder((String)"Organization").add("Asn", (Object)this.asn()).add("AsnOrg", (Object)this.asnOrg()).add("Isp", (Object)this.isp()).add("Org", (Object)this.org()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Asn": {
                return Optional.ofNullable(clazz.cast(this.asn()));
            }
            case "AsnOrg": {
                return Optional.ofNullable(clazz.cast(this.asnOrg()));
            }
            case "Isp": {
                return Optional.ofNullable(clazz.cast(this.isp()));
            }
            case "Org": {
                return Optional.ofNullable(clazz.cast(this.org()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Organization, T> g) {
        return obj -> g.apply((Organization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String asn;
        private String asnOrg;
        private String isp;
        private String org;

        private BuilderImpl() {
        }

        private BuilderImpl(Organization model) {
            this.asn(model.asn);
            this.asnOrg(model.asnOrg);
            this.isp(model.isp);
            this.org(model.org);
        }

        public final String getAsn() {
            return this.asn;
        }

        @Override
        public final Builder asn(String asn) {
            this.asn = asn;
            return this;
        }

        public final void setAsn(String asn) {
            this.asn = asn;
        }

        public final String getAsnOrg() {
            return this.asnOrg;
        }

        @Override
        public final Builder asnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
            return this;
        }

        public final void setAsnOrg(String asnOrg) {
            this.asnOrg = asnOrg;
        }

        public final String getIsp() {
            return this.isp;
        }

        @Override
        public final Builder isp(String isp) {
            this.isp = isp;
            return this;
        }

        public final void setIsp(String isp) {
            this.isp = isp;
        }

        public final String getOrg() {
            return this.org;
        }

        @Override
        public final Builder org(String org) {
            this.org = org;
            return this;
        }

        public final void setOrg(String org) {
            this.org = org;
        }

        public Organization build() {
            return new Organization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Organization> {
        public Builder asn(String var1);

        public Builder asnOrg(String var1);

        public Builder isp(String var1);

        public Builder org(String var1);
    }
}

