/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.ConfigCapabilityType;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, UpdateConfigResponse> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(UpdateConfigResponse.getter(UpdateConfigResponse::configId)).setter(UpdateConfigResponse.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<String> CONFIG_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configType").getter(UpdateConfigResponse.getter(UpdateConfigResponse::configTypeAsString)).setter(UpdateConfigResponse.setter(Builder::configType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configType").build()}).build();
    private static final SdkField<String> CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configArn").getter(UpdateConfigResponse.getter(UpdateConfigResponse::configArn)).setter(UpdateConfigResponse.setter(Builder::configArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, CONFIG_TYPE_FIELD, CONFIG_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConfigResponse.memberNameToFieldInitializer();
    private final String configId;
    private final String configType;
    private final String configArn;

    private UpdateConfigResponse(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.configType = builder.configType;
        this.configArn = builder.configArn;
    }

    public final String configId() {
        return this.configId;
    }

    public final ConfigCapabilityType configType() {
        return ConfigCapabilityType.fromValue(this.configType);
    }

    public final String configTypeAsString() {
        return this.configType;
    }

    public final String configArn() {
        return this.configArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.configTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigResponse)) {
            return false;
        }
        UpdateConfigResponse other = (UpdateConfigResponse)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.configTypeAsString(), other.configTypeAsString()) && Objects.equals(this.configArn(), other.configArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfigResponse").add("ConfigId", (Object)this.configId()).add("ConfigType", (Object)this.configTypeAsString()).add("ConfigArn", (Object)this.configArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "configType": {
                return Optional.ofNullable(clazz.cast(this.configTypeAsString()));
            }
            case "configArn": {
                return Optional.ofNullable(clazz.cast(this.configArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("configType", CONFIG_TYPE_FIELD);
        map.put("configArn", CONFIG_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigResponse, T> g) {
        return obj -> g.apply((UpdateConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String configId;
        private String configType;
        private String configArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigResponse model) {
            super(model);
            this.configId(model.configId);
            this.configType(model.configType);
            this.configArn(model.configArn);
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final String getConfigType() {
            return this.configType;
        }

        public final void setConfigType(String configType) {
            this.configType = configType;
        }

        @Override
        public final Builder configType(String configType) {
            this.configType = configType;
            return this;
        }

        @Override
        public final Builder configType(ConfigCapabilityType configType) {
            this.configType(configType == null ? null : configType.toString());
            return this;
        }

        public final String getConfigArn() {
            return this.configArn;
        }

        public final void setConfigArn(String configArn) {
            this.configArn = configArn;
        }

        @Override
        public final Builder configArn(String configArn) {
            this.configArn = configArn;
            return this;
        }

        @Override
        public UpdateConfigResponse build() {
            return new UpdateConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigResponse> {
        public Builder configId(String var1);

        public Builder configType(String var1);

        public Builder configType(ConfigCapabilityType var1);

        public Builder configArn(String var1);
    }
}

