/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.EphemeridesListCopier;
import software.amazon.awssdk.services.groundstation.model.EphemerisItem;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEphemeridesResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListEphemeridesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEphemeridesResponse.getter(ListEphemeridesResponse::nextToken)).setter(ListEphemeridesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<EphemerisItem>> EPHEMERIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ephemerides").getter(ListEphemeridesResponse.getter(ListEphemeridesResponse::ephemerides)).setter(ListEphemeridesResponse.setter(Builder::ephemerides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EphemerisItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, EPHEMERIDES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEphemeridesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<EphemerisItem> ephemerides;

    private ListEphemeridesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ephemerides = builder.ephemerides;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEphemerides() {
        return this.ephemerides != null && !(this.ephemerides instanceof SdkAutoConstructList);
    }

    public final List<EphemerisItem> ephemerides() {
        return this.ephemerides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEphemerides() ? this.ephemerides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEphemeridesResponse)) {
            return false;
        }
        ListEphemeridesResponse other = (ListEphemeridesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEphemerides() == other.hasEphemerides() && Objects.equals(this.ephemerides(), other.ephemerides());
    }

    public final String toString() {
        return ToString.builder((String)"ListEphemeridesResponse").add("NextToken", (Object)this.nextToken()).add("Ephemerides", this.hasEphemerides() ? this.ephemerides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ephemerides": {
                return Optional.ofNullable(clazz.cast(this.ephemerides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("ephemerides", EPHEMERIDES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEphemeridesResponse, T> g) {
        return obj -> g.apply((ListEphemeridesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<EphemerisItem> ephemerides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEphemeridesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ephemerides(model.ephemerides);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<EphemerisItem.Builder> getEphemerides() {
            List<EphemerisItem.Builder> result = EphemeridesListCopier.copyToBuilder(this.ephemerides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEphemerides(Collection<EphemerisItem.BuilderImpl> ephemerides) {
            this.ephemerides = EphemeridesListCopier.copyFromBuilder(ephemerides);
        }

        @Override
        public final Builder ephemerides(Collection<EphemerisItem> ephemerides) {
            this.ephemerides = EphemeridesListCopier.copy(ephemerides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ephemerides(EphemerisItem ... ephemerides) {
            this.ephemerides(Arrays.asList(ephemerides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ephemerides(Consumer<EphemerisItem.Builder> ... ephemerides) {
            this.ephemerides(Stream.of(ephemerides).map(c -> (EphemerisItem)((EphemerisItem.Builder)EphemerisItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEphemeridesResponse build() {
            return new ListEphemeridesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEphemeridesResponse> {
        public Builder nextToken(String var1);

        public Builder ephemerides(Collection<EphemerisItem> var1);

        public Builder ephemerides(EphemerisItem ... var1);

        public Builder ephemerides(Consumer<EphemerisItem.Builder> ... var1);
    }
}

