/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.EphemerisStatus;
import software.amazon.awssdk.services.groundstation.model.EphemerisType;
import software.amazon.awssdk.services.groundstation.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EphemerisItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EphemerisItem> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisId").getter(EphemerisItem.getter(EphemerisItem::ephemerisId)).setter(EphemerisItem.setter(Builder::ephemerisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()}).build();
    private static final SdkField<String> EPHEMERIS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ephemerisType").getter(EphemerisItem.getter(EphemerisItem::ephemerisTypeAsString)).setter(EphemerisItem.setter(Builder::ephemerisType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(EphemerisItem.getter(EphemerisItem::statusAsString)).setter(EphemerisItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(EphemerisItem.getter(EphemerisItem::priority)).setter(EphemerisItem.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(EphemerisItem.getter(EphemerisItem::enabled)).setter(EphemerisItem.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(EphemerisItem.getter(EphemerisItem::creationTime)).setter(EphemerisItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(EphemerisItem.getter(EphemerisItem::name)).setter(EphemerisItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<S3Object> SOURCE_S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceS3Object").getter(EphemerisItem.getter(EphemerisItem::sourceS3Object)).setter(EphemerisItem.setter(Builder::sourceS3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD, EPHEMERIS_TYPE_FIELD, STATUS_FIELD, PRIORITY_FIELD, ENABLED_FIELD, CREATION_TIME_FIELD, NAME_FIELD, SOURCE_S3_OBJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EphemerisItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ephemerisId;
    private final String ephemerisType;
    private final String status;
    private final Integer priority;
    private final Boolean enabled;
    private final Instant creationTime;
    private final String name;
    private final S3Object sourceS3Object;

    private EphemerisItem(BuilderImpl builder) {
        this.ephemerisId = builder.ephemerisId;
        this.ephemerisType = builder.ephemerisType;
        this.status = builder.status;
        this.priority = builder.priority;
        this.enabled = builder.enabled;
        this.creationTime = builder.creationTime;
        this.name = builder.name;
        this.sourceS3Object = builder.sourceS3Object;
    }

    public final String ephemerisId() {
        return this.ephemerisId;
    }

    public final EphemerisType ephemerisType() {
        return EphemerisType.fromValue(this.ephemerisType);
    }

    public final String ephemerisTypeAsString() {
        return this.ephemerisType;
    }

    public final EphemerisStatus status() {
        return EphemerisStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String name() {
        return this.name;
    }

    public final S3Object sourceS3Object() {
        return this.sourceS3Object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemerisTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3Object());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisItem)) {
            return false;
        }
        EphemerisItem other = (EphemerisItem)obj;
        return Objects.equals(this.ephemerisId(), other.ephemerisId()) && Objects.equals(this.ephemerisTypeAsString(), other.ephemerisTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceS3Object(), other.sourceS3Object());
    }

    public final String toString() {
        return ToString.builder((String)"EphemerisItem").add("EphemerisId", (Object)this.ephemerisId()).add("EphemerisType", (Object)this.ephemerisTypeAsString()).add("Status", (Object)this.statusAsString()).add("Priority", (Object)this.priority()).add("Enabled", (Object)this.enabled()).add("CreationTime", (Object)this.creationTime()).add("Name", (Object)this.name()).add("SourceS3Object", (Object)this.sourceS3Object()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ephemerisId": {
                return Optional.ofNullable(clazz.cast(this.ephemerisId()));
            }
            case "ephemerisType": {
                return Optional.ofNullable(clazz.cast(this.ephemerisTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "sourceS3Object": {
                return Optional.ofNullable(clazz.cast(this.sourceS3Object()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ephemerisId", EPHEMERIS_ID_FIELD);
        map.put("ephemerisType", EPHEMERIS_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("sourceS3Object", SOURCE_S3_OBJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EphemerisItem, T> g) {
        return obj -> g.apply((EphemerisItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ephemerisId;
        private String ephemerisType;
        private String status;
        private Integer priority;
        private Boolean enabled;
        private Instant creationTime;
        private String name;
        private S3Object sourceS3Object;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisItem model) {
            this.ephemerisId(model.ephemerisId);
            this.ephemerisType(model.ephemerisType);
            this.status(model.status);
            this.priority(model.priority);
            this.enabled(model.enabled);
            this.creationTime(model.creationTime);
            this.name(model.name);
            this.sourceS3Object(model.sourceS3Object);
        }

        public final String getEphemerisId() {
            return this.ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final String getEphemerisType() {
            return this.ephemerisType;
        }

        public final void setEphemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
        }

        @Override
        public final Builder ephemerisType(String ephemerisType) {
            this.ephemerisType = ephemerisType;
            return this;
        }

        @Override
        public final Builder ephemerisType(EphemerisType ephemerisType) {
            this.ephemerisType(ephemerisType == null ? null : ephemerisType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(EphemerisStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final S3Object.Builder getSourceS3Object() {
            return this.sourceS3Object != null ? this.sourceS3Object.toBuilder() : null;
        }

        public final void setSourceS3Object(S3Object.BuilderImpl sourceS3Object) {
            this.sourceS3Object = sourceS3Object != null ? sourceS3Object.build() : null;
        }

        @Override
        public final Builder sourceS3Object(S3Object sourceS3Object) {
            this.sourceS3Object = sourceS3Object;
            return this;
        }

        public EphemerisItem build() {
            return new EphemerisItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EphemerisItem> {
        public Builder ephemerisId(String var1);

        public Builder ephemerisType(String var1);

        public Builder ephemerisType(EphemerisType var1);

        public Builder status(String var1);

        public Builder status(EphemerisStatus var1);

        public Builder priority(Integer var1);

        public Builder enabled(Boolean var1);

        public Builder creationTime(Instant var1);

        public Builder name(String var1);

        public Builder sourceS3Object(S3Object var1);

        default public Builder sourceS3Object(Consumer<S3Object.Builder> sourceS3Object) {
            return this.sourceS3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(sourceS3Object)).build());
        }
    }
}

