/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.EphemerisData;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.services.groundstation.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEphemerisRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, CreateEphemerisRequest> {
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::satelliteId)).setter(CreateEphemerisRequest.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::enabled)).setter(CreateEphemerisRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::priority)).setter(CreateEphemerisRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Instant> EXPIRATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expirationTime").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::expirationTime)).setter(CreateEphemerisRequest.setter(Builder::expirationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationTime").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::name)).setter(CreateEphemerisRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::kmsKeyArn)).setter(CreateEphemerisRequest.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final SdkField<EphemerisData> EPHEMERIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ephemeris").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::ephemeris)).setter(CreateEphemerisRequest.setter(Builder::ephemeris)).constructor(EphemerisData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemeris").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateEphemerisRequest.getter(CreateEphemerisRequest::tags)).setter(CreateEphemerisRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SATELLITE_ID_FIELD, ENABLED_FIELD, PRIORITY_FIELD, EXPIRATION_TIME_FIELD, NAME_FIELD, KMS_KEY_ARN_FIELD, EPHEMERIS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEphemerisRequest.memberNameToFieldInitializer();
    private final String satelliteId;
    private final Boolean enabled;
    private final Integer priority;
    private final Instant expirationTime;
    private final String name;
    private final String kmsKeyArn;
    private final EphemerisData ephemeris;
    private final Map<String, String> tags;

    private CreateEphemerisRequest(BuilderImpl builder) {
        super(builder);
        this.satelliteId = builder.satelliteId;
        this.enabled = builder.enabled;
        this.priority = builder.priority;
        this.expirationTime = builder.expirationTime;
        this.name = builder.name;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.ephemeris = builder.ephemeris;
        this.tags = builder.tags;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Instant expirationTime() {
        return this.expirationTime;
    }

    public final String name() {
        return this.name;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public final EphemerisData ephemeris() {
        return this.ephemeris;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ephemeris());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEphemerisRequest)) {
            return false;
        }
        CreateEphemerisRequest other = (CreateEphemerisRequest)((Object)obj);
        return Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.expirationTime(), other.expirationTime()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn()) && Objects.equals(this.ephemeris(), other.ephemeris()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEphemerisRequest").add("SatelliteId", (Object)this.satelliteId()).add("Enabled", (Object)this.enabled()).add("Priority", (Object)this.priority()).add("ExpirationTime", (Object)this.expirationTime()).add("Name", (Object)this.name()).add("KmsKeyArn", (Object)this.kmsKeyArn()).add("Ephemeris", (Object)this.ephemeris()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "expirationTime": {
                return Optional.ofNullable(clazz.cast(this.expirationTime()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
            case "ephemeris": {
                return Optional.ofNullable(clazz.cast(this.ephemeris()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("enabled", ENABLED_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("expirationTime", EXPIRATION_TIME_FIELD);
        map.put("name", NAME_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        map.put("ephemeris", EPHEMERIS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEphemerisRequest, T> g) {
        return obj -> g.apply((CreateEphemerisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private String satelliteId;
        private Boolean enabled;
        private Integer priority;
        private Instant expirationTime;
        private String name;
        private String kmsKeyArn;
        private EphemerisData ephemeris;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEphemerisRequest model) {
            super(model);
            this.satelliteId(model.satelliteId);
            this.enabled(model.enabled);
            this.priority(model.priority);
            this.expirationTime(model.expirationTime);
            this.name(model.name);
            this.kmsKeyArn(model.kmsKeyArn);
            this.ephemeris(model.ephemeris);
            this.tags(model.tags);
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Instant getExpirationTime() {
            return this.expirationTime;
        }

        public final void setExpirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
        }

        @Override
        public final Builder expirationTime(Instant expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final EphemerisData.Builder getEphemeris() {
            return this.ephemeris != null ? this.ephemeris.toBuilder() : null;
        }

        public final void setEphemeris(EphemerisData.BuilderImpl ephemeris) {
            this.ephemeris = ephemeris != null ? ephemeris.build() : null;
        }

        @Override
        public final Builder ephemeris(EphemerisData ephemeris) {
            this.ephemeris = ephemeris;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEphemerisRequest build() {
            return new CreateEphemerisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEphemerisRequest> {
        public Builder satelliteId(String var1);

        public Builder enabled(Boolean var1);

        public Builder priority(Integer var1);

        public Builder expirationTime(Instant var1);

        public Builder name(String var1);

        public Builder kmsKeyArn(String var1);

        public Builder ephemeris(EphemerisData var1);

        default public Builder ephemeris(Consumer<EphemerisData.Builder> ephemeris) {
            return this.ephemeris((EphemerisData)((EphemerisData.Builder)EphemerisData.builder().applyMutation(ephemeris)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

