/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.groundstation.model.FrequencyUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Frequency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Frequency> {
    private static final SdkField<String> UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("units").getter(Frequency.getter(Frequency::unitsAsString)).setter(Frequency.setter(Builder::units)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("units").build()}).build();
    private static final SdkField<Double> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("value").getter(Frequency.getter(Frequency::value)).setter(Frequency.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNITS_FIELD, VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Frequency.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String units;
    private final Double value;

    private Frequency(BuilderImpl builder) {
        this.units = builder.units;
        this.value = builder.value;
    }

    public final FrequencyUnits units() {
        return FrequencyUnits.fromValue(this.units);
    }

    public final String unitsAsString() {
        return this.units;
    }

    public final Double value() {
        return this.value;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return Objects.equals(this.unitsAsString(), other.unitsAsString()) && Objects.equals(this.value(), other.value());
    }

    public final String toString() {
        return ToString.builder((String)"Frequency").add("Units", (Object)this.unitsAsString()).add("Value", (Object)this.value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "units": {
                return Optional.ofNullable(clazz.cast(this.unitsAsString()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("units", UNITS_FIELD);
        map.put("value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Frequency, T> g) {
        return obj -> g.apply((Frequency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String units;
        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(Frequency model) {
            this.units(model.units);
            this.value(model.value);
        }

        public final String getUnits() {
            return this.units;
        }

        public final void setUnits(String units) {
            this.units = units;
        }

        @Override
        public final Builder units(String units) {
            this.units = units;
            return this;
        }

        @Override
        public final Builder units(FrequencyUnits units) {
            this.units(units == null ? null : units.toString());
            return this;
        }

        public final Double getValue() {
            return this.value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public Frequency build() {
            return new Frequency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Frequency> {
        public Builder units(String var1);

        public Builder units(FrequencyUnits var1);

        public Builder value(Double var1);
    }
}

