/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.groundstation.model.AntennaDownlinkConfig;
import software.amazon.awssdk.services.groundstation.model.AntennaDownlinkDemodDecodeConfig;
import software.amazon.awssdk.services.groundstation.model.AntennaUplinkConfig;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointConfig;
import software.amazon.awssdk.services.groundstation.model.S3RecordingConfig;
import software.amazon.awssdk.services.groundstation.model.TrackingConfig;
import software.amazon.awssdk.services.groundstation.model.UplinkEchoConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigTypeData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigTypeData> {
    private static final SdkField<AntennaDownlinkConfig> ANTENNA_DOWNLINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaDownlinkConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaDownlinkConfig)).setter(ConfigTypeData.setter(Builder::antennaDownlinkConfig)).constructor(AntennaDownlinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkConfig").build()}).build();
    private static final SdkField<AntennaDownlinkDemodDecodeConfig> ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaDownlinkDemodDecodeConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaDownlinkDemodDecodeConfig)).setter(ConfigTypeData.setter(Builder::antennaDownlinkDemodDecodeConfig)).constructor(AntennaDownlinkDemodDecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaDownlinkDemodDecodeConfig").build()}).build();
    private static final SdkField<AntennaUplinkConfig> ANTENNA_UPLINK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("antennaUplinkConfig").getter(ConfigTypeData.getter(ConfigTypeData::antennaUplinkConfig)).setter(ConfigTypeData.setter(Builder::antennaUplinkConfig)).constructor(AntennaUplinkConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("antennaUplinkConfig").build()}).build();
    private static final SdkField<DataflowEndpointConfig> DATAFLOW_ENDPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataflowEndpointConfig").getter(ConfigTypeData.getter(ConfigTypeData::dataflowEndpointConfig)).setter(ConfigTypeData.setter(Builder::dataflowEndpointConfig)).constructor(DataflowEndpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointConfig").build()}).build();
    private static final SdkField<S3RecordingConfig> S3_RECORDING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3RecordingConfig").getter(ConfigTypeData.getter(ConfigTypeData::s3RecordingConfig)).setter(ConfigTypeData.setter(Builder::s3RecordingConfig)).constructor(S3RecordingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3RecordingConfig").build()}).build();
    private static final SdkField<TrackingConfig> TRACKING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trackingConfig").getter(ConfigTypeData.getter(ConfigTypeData::trackingConfig)).setter(ConfigTypeData.setter(Builder::trackingConfig)).constructor(TrackingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackingConfig").build()}).build();
    private static final SdkField<UplinkEchoConfig> UPLINK_ECHO_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("uplinkEchoConfig").getter(ConfigTypeData.getter(ConfigTypeData::uplinkEchoConfig)).setter(ConfigTypeData.setter(Builder::uplinkEchoConfig)).constructor(UplinkEchoConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uplinkEchoConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANTENNA_DOWNLINK_CONFIG_FIELD, ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD, ANTENNA_UPLINK_CONFIG_FIELD, DATAFLOW_ENDPOINT_CONFIG_FIELD, S3_RECORDING_CONFIG_FIELD, TRACKING_CONFIG_FIELD, UPLINK_ECHO_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigTypeData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AntennaDownlinkConfig antennaDownlinkConfig;
    private final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;
    private final AntennaUplinkConfig antennaUplinkConfig;
    private final DataflowEndpointConfig dataflowEndpointConfig;
    private final S3RecordingConfig s3RecordingConfig;
    private final TrackingConfig trackingConfig;
    private final UplinkEchoConfig uplinkEchoConfig;
    private final Type type;

    private ConfigTypeData(BuilderImpl builder) {
        this.antennaDownlinkConfig = builder.antennaDownlinkConfig;
        this.antennaDownlinkDemodDecodeConfig = builder.antennaDownlinkDemodDecodeConfig;
        this.antennaUplinkConfig = builder.antennaUplinkConfig;
        this.dataflowEndpointConfig = builder.dataflowEndpointConfig;
        this.s3RecordingConfig = builder.s3RecordingConfig;
        this.trackingConfig = builder.trackingConfig;
        this.uplinkEchoConfig = builder.uplinkEchoConfig;
        this.type = builder.type;
    }

    public final AntennaDownlinkConfig antennaDownlinkConfig() {
        return this.antennaDownlinkConfig;
    }

    public final AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig() {
        return this.antennaDownlinkDemodDecodeConfig;
    }

    public final AntennaUplinkConfig antennaUplinkConfig() {
        return this.antennaUplinkConfig;
    }

    public final DataflowEndpointConfig dataflowEndpointConfig() {
        return this.dataflowEndpointConfig;
    }

    public final S3RecordingConfig s3RecordingConfig() {
        return this.s3RecordingConfig;
    }

    public final TrackingConfig trackingConfig() {
        return this.trackingConfig;
    }

    public final UplinkEchoConfig uplinkEchoConfig() {
        return this.uplinkEchoConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaDownlinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaDownlinkDemodDecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.antennaUplinkConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataflowEndpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3RecordingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.uplinkEchoConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigTypeData)) {
            return false;
        }
        ConfigTypeData other = (ConfigTypeData)obj;
        return Objects.equals(this.antennaDownlinkConfig(), other.antennaDownlinkConfig()) && Objects.equals(this.antennaDownlinkDemodDecodeConfig(), other.antennaDownlinkDemodDecodeConfig()) && Objects.equals(this.antennaUplinkConfig(), other.antennaUplinkConfig()) && Objects.equals(this.dataflowEndpointConfig(), other.dataflowEndpointConfig()) && Objects.equals(this.s3RecordingConfig(), other.s3RecordingConfig()) && Objects.equals(this.trackingConfig(), other.trackingConfig()) && Objects.equals(this.uplinkEchoConfig(), other.uplinkEchoConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigTypeData").add("AntennaDownlinkConfig", (Object)this.antennaDownlinkConfig()).add("AntennaDownlinkDemodDecodeConfig", (Object)this.antennaDownlinkDemodDecodeConfig()).add("AntennaUplinkConfig", (Object)this.antennaUplinkConfig()).add("DataflowEndpointConfig", (Object)this.dataflowEndpointConfig()).add("S3RecordingConfig", (Object)this.s3RecordingConfig()).add("TrackingConfig", (Object)this.trackingConfig()).add("UplinkEchoConfig", (Object)this.uplinkEchoConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "antennaDownlinkConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaDownlinkConfig()));
            }
            case "antennaDownlinkDemodDecodeConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaDownlinkDemodDecodeConfig()));
            }
            case "antennaUplinkConfig": {
                return Optional.ofNullable(clazz.cast(this.antennaUplinkConfig()));
            }
            case "dataflowEndpointConfig": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointConfig()));
            }
            case "s3RecordingConfig": {
                return Optional.ofNullable(clazz.cast(this.s3RecordingConfig()));
            }
            case "trackingConfig": {
                return Optional.ofNullable(clazz.cast(this.trackingConfig()));
            }
            case "uplinkEchoConfig": {
                return Optional.ofNullable(clazz.cast(this.uplinkEchoConfig()));
            }
        }
        return Optional.empty();
    }

    public static ConfigTypeData fromAntennaDownlinkConfig(AntennaDownlinkConfig antennaDownlinkConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().antennaDownlinkConfig(antennaDownlinkConfig).build();
    }

    public static ConfigTypeData fromAntennaDownlinkConfig(Consumer<AntennaDownlinkConfig.Builder> antennaDownlinkConfig) {
        AntennaDownlinkConfig.Builder builder = AntennaDownlinkConfig.builder();
        antennaDownlinkConfig.accept(builder);
        return ConfigTypeData.fromAntennaDownlinkConfig((AntennaDownlinkConfig)builder.build());
    }

    public static ConfigTypeData fromAntennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().antennaDownlinkDemodDecodeConfig(antennaDownlinkDemodDecodeConfig).build();
    }

    public static ConfigTypeData fromAntennaDownlinkDemodDecodeConfig(Consumer<AntennaDownlinkDemodDecodeConfig.Builder> antennaDownlinkDemodDecodeConfig) {
        AntennaDownlinkDemodDecodeConfig.Builder builder = AntennaDownlinkDemodDecodeConfig.builder();
        antennaDownlinkDemodDecodeConfig.accept(builder);
        return ConfigTypeData.fromAntennaDownlinkDemodDecodeConfig((AntennaDownlinkDemodDecodeConfig)builder.build());
    }

    public static ConfigTypeData fromAntennaUplinkConfig(AntennaUplinkConfig antennaUplinkConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().antennaUplinkConfig(antennaUplinkConfig).build();
    }

    public static ConfigTypeData fromAntennaUplinkConfig(Consumer<AntennaUplinkConfig.Builder> antennaUplinkConfig) {
        AntennaUplinkConfig.Builder builder = AntennaUplinkConfig.builder();
        antennaUplinkConfig.accept(builder);
        return ConfigTypeData.fromAntennaUplinkConfig((AntennaUplinkConfig)builder.build());
    }

    public static ConfigTypeData fromDataflowEndpointConfig(DataflowEndpointConfig dataflowEndpointConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().dataflowEndpointConfig(dataflowEndpointConfig).build();
    }

    public static ConfigTypeData fromDataflowEndpointConfig(Consumer<DataflowEndpointConfig.Builder> dataflowEndpointConfig) {
        DataflowEndpointConfig.Builder builder = DataflowEndpointConfig.builder();
        dataflowEndpointConfig.accept(builder);
        return ConfigTypeData.fromDataflowEndpointConfig((DataflowEndpointConfig)builder.build());
    }

    public static ConfigTypeData fromS3RecordingConfig(S3RecordingConfig s3RecordingConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().s3RecordingConfig(s3RecordingConfig).build();
    }

    public static ConfigTypeData fromS3RecordingConfig(Consumer<S3RecordingConfig.Builder> s3RecordingConfig) {
        S3RecordingConfig.Builder builder = S3RecordingConfig.builder();
        s3RecordingConfig.accept(builder);
        return ConfigTypeData.fromS3RecordingConfig((S3RecordingConfig)builder.build());
    }

    public static ConfigTypeData fromTrackingConfig(TrackingConfig trackingConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().trackingConfig(trackingConfig).build();
    }

    public static ConfigTypeData fromTrackingConfig(Consumer<TrackingConfig.Builder> trackingConfig) {
        TrackingConfig.Builder builder = TrackingConfig.builder();
        trackingConfig.accept(builder);
        return ConfigTypeData.fromTrackingConfig((TrackingConfig)builder.build());
    }

    public static ConfigTypeData fromUplinkEchoConfig(UplinkEchoConfig uplinkEchoConfig) {
        return (ConfigTypeData)ConfigTypeData.builder().uplinkEchoConfig(uplinkEchoConfig).build();
    }

    public static ConfigTypeData fromUplinkEchoConfig(Consumer<UplinkEchoConfig.Builder> uplinkEchoConfig) {
        UplinkEchoConfig.Builder builder = UplinkEchoConfig.builder();
        uplinkEchoConfig.accept(builder);
        return ConfigTypeData.fromUplinkEchoConfig((UplinkEchoConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("antennaDownlinkConfig", ANTENNA_DOWNLINK_CONFIG_FIELD);
        map.put("antennaDownlinkDemodDecodeConfig", ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG_FIELD);
        map.put("antennaUplinkConfig", ANTENNA_UPLINK_CONFIG_FIELD);
        map.put("dataflowEndpointConfig", DATAFLOW_ENDPOINT_CONFIG_FIELD);
        map.put("s3RecordingConfig", S3_RECORDING_CONFIG_FIELD);
        map.put("trackingConfig", TRACKING_CONFIG_FIELD);
        map.put("uplinkEchoConfig", UPLINK_ECHO_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigTypeData, T> g) {
        return obj -> g.apply((ConfigTypeData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ANTENNA_DOWNLINK_CONFIG,
        ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG,
        ANTENNA_UPLINK_CONFIG,
        DATAFLOW_ENDPOINT_CONFIG,
        S3_RECORDING_CONFIG,
        TRACKING_CONFIG,
        UPLINK_ECHO_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AntennaDownlinkConfig antennaDownlinkConfig;
        private AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig;
        private AntennaUplinkConfig antennaUplinkConfig;
        private DataflowEndpointConfig dataflowEndpointConfig;
        private S3RecordingConfig s3RecordingConfig;
        private TrackingConfig trackingConfig;
        private UplinkEchoConfig uplinkEchoConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigTypeData model) {
            this.antennaDownlinkConfig(model.antennaDownlinkConfig);
            this.antennaDownlinkDemodDecodeConfig(model.antennaDownlinkDemodDecodeConfig);
            this.antennaUplinkConfig(model.antennaUplinkConfig);
            this.dataflowEndpointConfig(model.dataflowEndpointConfig);
            this.s3RecordingConfig(model.s3RecordingConfig);
            this.trackingConfig(model.trackingConfig);
            this.uplinkEchoConfig(model.uplinkEchoConfig);
        }

        public final AntennaDownlinkConfig.Builder getAntennaDownlinkConfig() {
            return this.antennaDownlinkConfig != null ? this.antennaDownlinkConfig.toBuilder() : null;
        }

        public final void setAntennaDownlinkConfig(AntennaDownlinkConfig.BuilderImpl antennaDownlinkConfig) {
            AntennaDownlinkConfig oldValue = this.antennaDownlinkConfig;
            this.antennaDownlinkConfig = antennaDownlinkConfig != null ? antennaDownlinkConfig.build() : null;
            this.handleUnionValueChange(Type.ANTENNA_DOWNLINK_CONFIG, oldValue, this.antennaDownlinkConfig);
        }

        @Override
        public final Builder antennaDownlinkConfig(AntennaDownlinkConfig antennaDownlinkConfig) {
            AntennaDownlinkConfig oldValue = this.antennaDownlinkConfig;
            this.antennaDownlinkConfig = antennaDownlinkConfig;
            this.handleUnionValueChange(Type.ANTENNA_DOWNLINK_CONFIG, oldValue, this.antennaDownlinkConfig);
            return this;
        }

        public final AntennaDownlinkDemodDecodeConfig.Builder getAntennaDownlinkDemodDecodeConfig() {
            return this.antennaDownlinkDemodDecodeConfig != null ? this.antennaDownlinkDemodDecodeConfig.toBuilder() : null;
        }

        public final void setAntennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig.BuilderImpl antennaDownlinkDemodDecodeConfig) {
            AntennaDownlinkDemodDecodeConfig oldValue = this.antennaDownlinkDemodDecodeConfig;
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig != null ? antennaDownlinkDemodDecodeConfig.build() : null;
            this.handleUnionValueChange(Type.ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG, oldValue, this.antennaDownlinkDemodDecodeConfig);
        }

        @Override
        public final Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig antennaDownlinkDemodDecodeConfig) {
            AntennaDownlinkDemodDecodeConfig oldValue = this.antennaDownlinkDemodDecodeConfig;
            this.antennaDownlinkDemodDecodeConfig = antennaDownlinkDemodDecodeConfig;
            this.handleUnionValueChange(Type.ANTENNA_DOWNLINK_DEMOD_DECODE_CONFIG, oldValue, this.antennaDownlinkDemodDecodeConfig);
            return this;
        }

        public final AntennaUplinkConfig.Builder getAntennaUplinkConfig() {
            return this.antennaUplinkConfig != null ? this.antennaUplinkConfig.toBuilder() : null;
        }

        public final void setAntennaUplinkConfig(AntennaUplinkConfig.BuilderImpl antennaUplinkConfig) {
            AntennaUplinkConfig oldValue = this.antennaUplinkConfig;
            this.antennaUplinkConfig = antennaUplinkConfig != null ? antennaUplinkConfig.build() : null;
            this.handleUnionValueChange(Type.ANTENNA_UPLINK_CONFIG, oldValue, this.antennaUplinkConfig);
        }

        @Override
        public final Builder antennaUplinkConfig(AntennaUplinkConfig antennaUplinkConfig) {
            AntennaUplinkConfig oldValue = this.antennaUplinkConfig;
            this.antennaUplinkConfig = antennaUplinkConfig;
            this.handleUnionValueChange(Type.ANTENNA_UPLINK_CONFIG, oldValue, this.antennaUplinkConfig);
            return this;
        }

        public final DataflowEndpointConfig.Builder getDataflowEndpointConfig() {
            return this.dataflowEndpointConfig != null ? this.dataflowEndpointConfig.toBuilder() : null;
        }

        public final void setDataflowEndpointConfig(DataflowEndpointConfig.BuilderImpl dataflowEndpointConfig) {
            DataflowEndpointConfig oldValue = this.dataflowEndpointConfig;
            this.dataflowEndpointConfig = dataflowEndpointConfig != null ? dataflowEndpointConfig.build() : null;
            this.handleUnionValueChange(Type.DATAFLOW_ENDPOINT_CONFIG, oldValue, this.dataflowEndpointConfig);
        }

        @Override
        public final Builder dataflowEndpointConfig(DataflowEndpointConfig dataflowEndpointConfig) {
            DataflowEndpointConfig oldValue = this.dataflowEndpointConfig;
            this.dataflowEndpointConfig = dataflowEndpointConfig;
            this.handleUnionValueChange(Type.DATAFLOW_ENDPOINT_CONFIG, oldValue, this.dataflowEndpointConfig);
            return this;
        }

        public final S3RecordingConfig.Builder getS3RecordingConfig() {
            return this.s3RecordingConfig != null ? this.s3RecordingConfig.toBuilder() : null;
        }

        public final void setS3RecordingConfig(S3RecordingConfig.BuilderImpl s3RecordingConfig) {
            S3RecordingConfig oldValue = this.s3RecordingConfig;
            this.s3RecordingConfig = s3RecordingConfig != null ? s3RecordingConfig.build() : null;
            this.handleUnionValueChange(Type.S3_RECORDING_CONFIG, oldValue, this.s3RecordingConfig);
        }

        @Override
        public final Builder s3RecordingConfig(S3RecordingConfig s3RecordingConfig) {
            S3RecordingConfig oldValue = this.s3RecordingConfig;
            this.s3RecordingConfig = s3RecordingConfig;
            this.handleUnionValueChange(Type.S3_RECORDING_CONFIG, oldValue, this.s3RecordingConfig);
            return this;
        }

        public final TrackingConfig.Builder getTrackingConfig() {
            return this.trackingConfig != null ? this.trackingConfig.toBuilder() : null;
        }

        public final void setTrackingConfig(TrackingConfig.BuilderImpl trackingConfig) {
            TrackingConfig oldValue = this.trackingConfig;
            this.trackingConfig = trackingConfig != null ? trackingConfig.build() : null;
            this.handleUnionValueChange(Type.TRACKING_CONFIG, oldValue, this.trackingConfig);
        }

        @Override
        public final Builder trackingConfig(TrackingConfig trackingConfig) {
            TrackingConfig oldValue = this.trackingConfig;
            this.trackingConfig = trackingConfig;
            this.handleUnionValueChange(Type.TRACKING_CONFIG, oldValue, this.trackingConfig);
            return this;
        }

        public final UplinkEchoConfig.Builder getUplinkEchoConfig() {
            return this.uplinkEchoConfig != null ? this.uplinkEchoConfig.toBuilder() : null;
        }

        public final void setUplinkEchoConfig(UplinkEchoConfig.BuilderImpl uplinkEchoConfig) {
            UplinkEchoConfig oldValue = this.uplinkEchoConfig;
            this.uplinkEchoConfig = uplinkEchoConfig != null ? uplinkEchoConfig.build() : null;
            this.handleUnionValueChange(Type.UPLINK_ECHO_CONFIG, oldValue, this.uplinkEchoConfig);
        }

        @Override
        public final Builder uplinkEchoConfig(UplinkEchoConfig uplinkEchoConfig) {
            UplinkEchoConfig oldValue = this.uplinkEchoConfig;
            this.uplinkEchoConfig = uplinkEchoConfig;
            this.handleUnionValueChange(Type.UPLINK_ECHO_CONFIG, oldValue, this.uplinkEchoConfig);
            return this;
        }

        public ConfigTypeData build() {
            return new ConfigTypeData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigTypeData> {
        public Builder antennaDownlinkConfig(AntennaDownlinkConfig var1);

        default public Builder antennaDownlinkConfig(Consumer<AntennaDownlinkConfig.Builder> antennaDownlinkConfig) {
            return this.antennaDownlinkConfig((AntennaDownlinkConfig)((AntennaDownlinkConfig.Builder)AntennaDownlinkConfig.builder().applyMutation(antennaDownlinkConfig)).build());
        }

        public Builder antennaDownlinkDemodDecodeConfig(AntennaDownlinkDemodDecodeConfig var1);

        default public Builder antennaDownlinkDemodDecodeConfig(Consumer<AntennaDownlinkDemodDecodeConfig.Builder> antennaDownlinkDemodDecodeConfig) {
            return this.antennaDownlinkDemodDecodeConfig((AntennaDownlinkDemodDecodeConfig)((AntennaDownlinkDemodDecodeConfig.Builder)AntennaDownlinkDemodDecodeConfig.builder().applyMutation(antennaDownlinkDemodDecodeConfig)).build());
        }

        public Builder antennaUplinkConfig(AntennaUplinkConfig var1);

        default public Builder antennaUplinkConfig(Consumer<AntennaUplinkConfig.Builder> antennaUplinkConfig) {
            return this.antennaUplinkConfig((AntennaUplinkConfig)((AntennaUplinkConfig.Builder)AntennaUplinkConfig.builder().applyMutation(antennaUplinkConfig)).build());
        }

        public Builder dataflowEndpointConfig(DataflowEndpointConfig var1);

        default public Builder dataflowEndpointConfig(Consumer<DataflowEndpointConfig.Builder> dataflowEndpointConfig) {
            return this.dataflowEndpointConfig((DataflowEndpointConfig)((DataflowEndpointConfig.Builder)DataflowEndpointConfig.builder().applyMutation(dataflowEndpointConfig)).build());
        }

        public Builder s3RecordingConfig(S3RecordingConfig var1);

        default public Builder s3RecordingConfig(Consumer<S3RecordingConfig.Builder> s3RecordingConfig) {
            return this.s3RecordingConfig((S3RecordingConfig)((S3RecordingConfig.Builder)S3RecordingConfig.builder().applyMutation(s3RecordingConfig)).build());
        }

        public Builder trackingConfig(TrackingConfig var1);

        default public Builder trackingConfig(Consumer<TrackingConfig.Builder> trackingConfig) {
            return this.trackingConfig((TrackingConfig)((TrackingConfig.Builder)TrackingConfig.builder().applyMutation(trackingConfig)).build());
        }

        public Builder uplinkEchoConfig(UplinkEchoConfig var1);

        default public Builder uplinkEchoConfig(Consumer<UplinkEchoConfig.Builder> uplinkEchoConfig) {
            return this.uplinkEchoConfig((UplinkEchoConfig)((UplinkEchoConfig.Builder)UplinkEchoConfig.builder().applyMutation(uplinkEchoConfig)).build());
        }
    }
}

