/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.AggregateStatus;
import software.amazon.awssdk.services.groundstation.model.ComponentStatusData;
import software.amazon.awssdk.services.groundstation.model.ComponentStatusListCopier;
import software.amazon.awssdk.services.groundstation.model.GroundStationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAgentStatusRequest
extends GroundStationRequest
implements ToCopyableBuilder<Builder, UpdateAgentStatusRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::agentId)).setter(UpdateAgentStatusRequest.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()}).build();
    private static final SdkField<AggregateStatus> AGGREGATE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("aggregateStatus").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::aggregateStatus)).setter(UpdateAgentStatusRequest.setter(Builder::aggregateStatus)).constructor(AggregateStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregateStatus").build()}).build();
    private static final SdkField<List<ComponentStatusData>> COMPONENT_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentStatuses").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::componentStatuses)).setter(UpdateAgentStatusRequest.setter(Builder::componentStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentStatusData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(UpdateAgentStatusRequest.getter(UpdateAgentStatusRequest::taskId)).setter(UpdateAgentStatusRequest.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGGREGATE_STATUS_FIELD, COMPONENT_STATUSES_FIELD, TASK_ID_FIELD));
    private final String agentId;
    private final AggregateStatus aggregateStatus;
    private final List<ComponentStatusData> componentStatuses;
    private final String taskId;

    private UpdateAgentStatusRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.aggregateStatus = builder.aggregateStatus;
        this.componentStatuses = builder.componentStatuses;
        this.taskId = builder.taskId;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final AggregateStatus aggregateStatus() {
        return this.aggregateStatus;
    }

    public final boolean hasComponentStatuses() {
        return this.componentStatuses != null && !(this.componentStatuses instanceof SdkAutoConstructList);
    }

    public final List<ComponentStatusData> componentStatuses() {
        return this.componentStatuses;
    }

    public final String taskId() {
        return this.taskId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregateStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentStatuses() ? this.componentStatuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentStatusRequest)) {
            return false;
        }
        UpdateAgentStatusRequest other = (UpdateAgentStatusRequest)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.aggregateStatus(), other.aggregateStatus()) && this.hasComponentStatuses() == other.hasComponentStatuses() && Objects.equals(this.componentStatuses(), other.componentStatuses()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAgentStatusRequest").add("AgentId", (Object)this.agentId()).add("AggregateStatus", (Object)this.aggregateStatus()).add("ComponentStatuses", this.hasComponentStatuses() ? this.componentStatuses() : null).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "aggregateStatus": {
                return Optional.ofNullable(clazz.cast(this.aggregateStatus()));
            }
            case "componentStatuses": {
                return Optional.ofNullable(clazz.cast(this.componentStatuses()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentStatusRequest, T> g) {
        return obj -> g.apply((UpdateAgentStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationRequest.BuilderImpl
    implements Builder {
        private String agentId;
        private AggregateStatus aggregateStatus;
        private List<ComponentStatusData> componentStatuses = DefaultSdkAutoConstructList.getInstance();
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentStatusRequest model) {
            super(model);
            this.agentId(model.agentId);
            this.aggregateStatus(model.aggregateStatus);
            this.componentStatuses(model.componentStatuses);
            this.taskId(model.taskId);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final AggregateStatus.Builder getAggregateStatus() {
            return this.aggregateStatus != null ? this.aggregateStatus.toBuilder() : null;
        }

        public final void setAggregateStatus(AggregateStatus.BuilderImpl aggregateStatus) {
            this.aggregateStatus = aggregateStatus != null ? aggregateStatus.build() : null;
        }

        @Override
        public final Builder aggregateStatus(AggregateStatus aggregateStatus) {
            this.aggregateStatus = aggregateStatus;
            return this;
        }

        public final List<ComponentStatusData.Builder> getComponentStatuses() {
            List<ComponentStatusData.Builder> result = ComponentStatusListCopier.copyToBuilder(this.componentStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentStatuses(Collection<ComponentStatusData.BuilderImpl> componentStatuses) {
            this.componentStatuses = ComponentStatusListCopier.copyFromBuilder(componentStatuses);
        }

        @Override
        public final Builder componentStatuses(Collection<ComponentStatusData> componentStatuses) {
            this.componentStatuses = ComponentStatusListCopier.copy(componentStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentStatuses(ComponentStatusData ... componentStatuses) {
            this.componentStatuses(Arrays.asList(componentStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentStatuses(Consumer<ComponentStatusData.Builder> ... componentStatuses) {
            this.componentStatuses(Stream.of(componentStatuses).map(c -> (ComponentStatusData)((ComponentStatusData.Builder)ComponentStatusData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentStatusRequest build() {
            return new UpdateAgentStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GroundStationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAgentStatusRequest> {
        public Builder agentId(String var1);

        public Builder aggregateStatus(AggregateStatus var1);

        default public Builder aggregateStatus(Consumer<AggregateStatus.Builder> aggregateStatus) {
            return this.aggregateStatus((AggregateStatus)((AggregateStatus.Builder)AggregateStatus.builder().applyMutation(aggregateStatus)).build());
        }

        public Builder componentStatuses(Collection<ComponentStatusData> var1);

        public Builder componentStatuses(ComponentStatusData ... var1);

        public Builder componentStatuses(Consumer<ComponentStatusData.Builder> ... var1);

        public Builder taskId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

