/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.AwsGroundStationAgentEndpoint;
import software.amazon.awssdk.services.groundstation.model.CapabilityHealth;
import software.amazon.awssdk.services.groundstation.model.CapabilityHealthReason;
import software.amazon.awssdk.services.groundstation.model.CapabilityHealthReasonListCopier;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpoint;
import software.amazon.awssdk.services.groundstation.model.SecurityDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EndpointDetails> {
    private static final SdkField<AwsGroundStationAgentEndpoint> AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("awsGroundStationAgentEndpoint").getter(EndpointDetails.getter(EndpointDetails::awsGroundStationAgentEndpoint)).setter(EndpointDetails.setter(Builder::awsGroundStationAgentEndpoint)).constructor(AwsGroundStationAgentEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsGroundStationAgentEndpoint").build()}).build();
    private static final SdkField<DataflowEndpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpoint").getter(EndpointDetails.getter(EndpointDetails::endpoint)).setter(EndpointDetails.setter(Builder::endpoint)).constructor(DataflowEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<List<String>> HEALTH_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("healthReasons").getter(EndpointDetails.getter(EndpointDetails::healthReasonsAsStrings)).setter(EndpointDetails.setter(Builder::healthReasonsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthStatus").getter(EndpointDetails.getter(EndpointDetails::healthStatusAsString)).setter(EndpointDetails.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<SecurityDetails> SECURITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("securityDetails").getter(EndpointDetails.getter(EndpointDetails::securityDetails)).setter(EndpointDetails.setter(Builder::securityDetails)).constructor(SecurityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD, ENDPOINT_FIELD, HEALTH_REASONS_FIELD, HEALTH_STATUS_FIELD, SECURITY_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EndpointDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint;
    private final DataflowEndpoint endpoint;
    private final List<String> healthReasons;
    private final String healthStatus;
    private final SecurityDetails securityDetails;

    private EndpointDetails(BuilderImpl builder) {
        this.awsGroundStationAgentEndpoint = builder.awsGroundStationAgentEndpoint;
        this.endpoint = builder.endpoint;
        this.healthReasons = builder.healthReasons;
        this.healthStatus = builder.healthStatus;
        this.securityDetails = builder.securityDetails;
    }

    public final AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint() {
        return this.awsGroundStationAgentEndpoint;
    }

    public final DataflowEndpoint endpoint() {
        return this.endpoint;
    }

    public final List<CapabilityHealthReason> healthReasons() {
        return CapabilityHealthReasonListCopier.copyStringToEnum(this.healthReasons);
    }

    public final boolean hasHealthReasons() {
        return this.healthReasons != null && !(this.healthReasons instanceof SdkAutoConstructList);
    }

    public final List<String> healthReasonsAsStrings() {
        return this.healthReasons;
    }

    public final CapabilityHealth healthStatus() {
        return CapabilityHealth.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final SecurityDetails securityDetails() {
        return this.securityDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsGroundStationAgentEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHealthReasons() ? this.healthReasonsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointDetails)) {
            return false;
        }
        EndpointDetails other = (EndpointDetails)obj;
        return Objects.equals(this.awsGroundStationAgentEndpoint(), other.awsGroundStationAgentEndpoint()) && Objects.equals(this.endpoint(), other.endpoint()) && this.hasHealthReasons() == other.hasHealthReasons() && Objects.equals(this.healthReasonsAsStrings(), other.healthReasonsAsStrings()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.securityDetails(), other.securityDetails());
    }

    public final String toString() {
        return ToString.builder((String)"EndpointDetails").add("AwsGroundStationAgentEndpoint", (Object)this.awsGroundStationAgentEndpoint()).add("Endpoint", (Object)this.endpoint()).add("HealthReasons", this.hasHealthReasons() ? this.healthReasonsAsStrings() : null).add("HealthStatus", (Object)this.healthStatusAsString()).add("SecurityDetails", (Object)this.securityDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsGroundStationAgentEndpoint": {
                return Optional.ofNullable(clazz.cast(this.awsGroundStationAgentEndpoint()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "healthReasons": {
                return Optional.ofNullable(clazz.cast(this.healthReasonsAsStrings()));
            }
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "securityDetails": {
                return Optional.ofNullable(clazz.cast(this.securityDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("awsGroundStationAgentEndpoint", AWS_GROUND_STATION_AGENT_ENDPOINT_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("healthReasons", HEALTH_REASONS_FIELD);
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        map.put("securityDetails", SECURITY_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointDetails, T> g) {
        return obj -> g.apply((EndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint;
        private DataflowEndpoint endpoint;
        private List<String> healthReasons = DefaultSdkAutoConstructList.getInstance();
        private String healthStatus;
        private SecurityDetails securityDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointDetails model) {
            this.awsGroundStationAgentEndpoint(model.awsGroundStationAgentEndpoint);
            this.endpoint(model.endpoint);
            this.healthReasonsWithStrings(model.healthReasons);
            this.healthStatus(model.healthStatus);
            this.securityDetails(model.securityDetails);
        }

        public final AwsGroundStationAgentEndpoint.Builder getAwsGroundStationAgentEndpoint() {
            return this.awsGroundStationAgentEndpoint != null ? this.awsGroundStationAgentEndpoint.toBuilder() : null;
        }

        public final void setAwsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint.BuilderImpl awsGroundStationAgentEndpoint) {
            this.awsGroundStationAgentEndpoint = awsGroundStationAgentEndpoint != null ? awsGroundStationAgentEndpoint.build() : null;
        }

        @Override
        public final Builder awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint awsGroundStationAgentEndpoint) {
            this.awsGroundStationAgentEndpoint = awsGroundStationAgentEndpoint;
            return this;
        }

        public final DataflowEndpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(DataflowEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(DataflowEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Collection<String> getHealthReasons() {
            if (this.healthReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.healthReasons;
        }

        public final void setHealthReasons(Collection<String> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copy(healthReasons);
        }

        @Override
        public final Builder healthReasonsWithStrings(Collection<String> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copy(healthReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthReasonsWithStrings(String ... healthReasons) {
            this.healthReasonsWithStrings(Arrays.asList(healthReasons));
            return this;
        }

        @Override
        public final Builder healthReasons(Collection<CapabilityHealthReason> healthReasons) {
            this.healthReasons = CapabilityHealthReasonListCopier.copyEnumToString(healthReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthReasons(CapabilityHealthReason ... healthReasons) {
            this.healthReasons(Arrays.asList(healthReasons));
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(CapabilityHealth healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final SecurityDetails.Builder getSecurityDetails() {
            return this.securityDetails != null ? this.securityDetails.toBuilder() : null;
        }

        public final void setSecurityDetails(SecurityDetails.BuilderImpl securityDetails) {
            this.securityDetails = securityDetails != null ? securityDetails.build() : null;
        }

        @Override
        public final Builder securityDetails(SecurityDetails securityDetails) {
            this.securityDetails = securityDetails;
            return this;
        }

        public EndpointDetails build() {
            return new EndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EndpointDetails> {
        public Builder awsGroundStationAgentEndpoint(AwsGroundStationAgentEndpoint var1);

        default public Builder awsGroundStationAgentEndpoint(Consumer<AwsGroundStationAgentEndpoint.Builder> awsGroundStationAgentEndpoint) {
            return this.awsGroundStationAgentEndpoint((AwsGroundStationAgentEndpoint)((AwsGroundStationAgentEndpoint.Builder)AwsGroundStationAgentEndpoint.builder().applyMutation(awsGroundStationAgentEndpoint)).build());
        }

        public Builder endpoint(DataflowEndpoint var1);

        default public Builder endpoint(Consumer<DataflowEndpoint.Builder> endpoint) {
            return this.endpoint((DataflowEndpoint)((DataflowEndpoint.Builder)DataflowEndpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder healthReasonsWithStrings(Collection<String> var1);

        public Builder healthReasonsWithStrings(String ... var1);

        public Builder healthReasons(Collection<CapabilityHealthReason> var1);

        public Builder healthReasons(CapabilityHealthReason ... var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(CapabilityHealth var1);

        public Builder securityDetails(SecurityDetails var1);

        default public Builder securityDetails(Consumer<SecurityDetails.Builder> securityDetails) {
            return this.securityDetails((SecurityDetails)((SecurityDetails.Builder)SecurityDetails.builder().applyMutation(securityDetails)).build());
        }
    }
}

