/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.groundstation.DefaultGroundStationBaseClientBuilder;
import software.amazon.awssdk.services.groundstation.DefaultGroundStationClient;
import software.amazon.awssdk.services.groundstation.GroundStationClient;
import software.amazon.awssdk.services.groundstation.GroundStationClientBuilder;
import software.amazon.awssdk.services.groundstation.GroundStationServiceClientConfiguration;
import software.amazon.awssdk.services.groundstation.endpoints.GroundStationEndpointProvider;

@SdkInternalApi
final class DefaultGroundStationClientBuilder
extends DefaultGroundStationBaseClientBuilder<GroundStationClientBuilder, GroundStationClient>
implements GroundStationClientBuilder {
    DefaultGroundStationClientBuilder() {
    }

    @Override
    public DefaultGroundStationClientBuilder endpointProvider(GroundStationEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final GroundStationClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultGroundStationClientBuilder.validateClientOptions(clientConfiguration);
        GroundStationServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultGroundStationClient client = new DefaultGroundStationClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private GroundStationServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return GroundStationServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

