/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata describing a particular ephemeris.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EphemerisMetaData implements SdkPojo, Serializable,
        ToCopyableBuilder<EphemerisMetaData.Builder, EphemerisMetaData> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(EphemerisMetaData::ephemerisId)).setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ephemerisId").build()).build();

    private static final SdkField<Instant> EPOCH_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("epoch")
            .getter(getter(EphemerisMetaData::epoch)).setter(setter(Builder::epoch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("epoch").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EphemerisMetaData::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(EphemerisMetaData::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD,
            EPOCH_FIELD, NAME_FIELD, SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ephemerisId;

    private final Instant epoch;

    private final String name;

    private final String source;

    private EphemerisMetaData(BuilderImpl builder) {
        this.ephemerisId = builder.ephemerisId;
        this.epoch = builder.epoch;
        this.name = builder.name;
        this.source = builder.source;
    }

    /**
     * <p>
     * UUID of a customer-provided ephemeris.
     * </p>
     * <p>
     * This field is not populated for default ephemerides from Space Track.
     * </p>
     * 
     * @return UUID of a customer-provided ephemeris.</p>
     *         <p>
     *         This field is not populated for default ephemerides from Space Track.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    /**
     * <p>
     * The epoch of a default, ephemeris from Space Track in UTC.
     * </p>
     * <p>
     * This field is not populated for customer-provided ephemerides.
     * </p>
     * 
     * @return The epoch of a default, ephemeris from Space Track in UTC.</p>
     *         <p>
     *         This field is not populated for customer-provided ephemerides.
     */
    public final Instant epoch() {
        return epoch;
    }

    /**
     * <p>
     * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
     * </p>
     * <p>
     * A name is only returned for customer-provider ephemerides that have a name associated.
     * </p>
     * 
     * @return A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.</p>
     *         <p>
     *         A name is only returned for customer-provider ephemerides that have a name associated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>EphemerisSource</code> that generated a given ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link EphemerisSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The <code>EphemerisSource</code> that generated a given ephemeris.
     * @see EphemerisSource
     */
    public final EphemerisSource source() {
        return EphemerisSource.fromValue(source);
    }

    /**
     * <p>
     * The <code>EphemerisSource</code> that generated a given ephemeris.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link EphemerisSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return The <code>EphemerisSource</code> that generated a given ephemeris.
     * @see EphemerisSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        hashCode = 31 * hashCode + Objects.hashCode(epoch());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EphemerisMetaData)) {
            return false;
        }
        EphemerisMetaData other = (EphemerisMetaData) obj;
        return Objects.equals(ephemerisId(), other.ephemerisId()) && Objects.equals(epoch(), other.epoch())
                && Objects.equals(name(), other.name()) && Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EphemerisMetaData").add("EphemerisId", ephemerisId()).add("Epoch", epoch()).add("Name", name())
                .add("Source", sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        case "epoch":
            return Optional.ofNullable(clazz.cast(epoch()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EphemerisMetaData, T> g) {
        return obj -> g.apply((EphemerisMetaData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EphemerisMetaData> {
        /**
         * <p>
         * UUID of a customer-provided ephemeris.
         * </p>
         * <p>
         * This field is not populated for default ephemerides from Space Track.
         * </p>
         * 
         * @param ephemerisId
         *        UUID of a customer-provided ephemeris.</p>
         *        <p>
         *        This field is not populated for default ephemerides from Space Track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        /**
         * <p>
         * The epoch of a default, ephemeris from Space Track in UTC.
         * </p>
         * <p>
         * This field is not populated for customer-provided ephemerides.
         * </p>
         * 
         * @param epoch
         *        The epoch of a default, ephemeris from Space Track in UTC.</p>
         *        <p>
         *        This field is not populated for customer-provided ephemerides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder epoch(Instant epoch);

        /**
         * <p>
         * A name string associated with the ephemeris. Used as a human-readable identifier for the ephemeris.
         * </p>
         * <p>
         * A name is only returned for customer-provider ephemerides that have a name associated.
         * </p>
         * 
         * @param name
         *        A name string associated with the ephemeris. Used as a human-readable identifier for the
         *        ephemeris.</p>
         *        <p>
         *        A name is only returned for customer-provider ephemerides that have a name associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>EphemerisSource</code> that generated a given ephemeris.
         * </p>
         * 
         * @param source
         *        The <code>EphemerisSource</code> that generated a given ephemeris.
         * @see EphemerisSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisSource
         */
        Builder source(String source);

        /**
         * <p>
         * The <code>EphemerisSource</code> that generated a given ephemeris.
         * </p>
         * 
         * @param source
         *        The <code>EphemerisSource</code> that generated a given ephemeris.
         * @see EphemerisSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EphemerisSource
         */
        Builder source(EphemerisSource source);
    }

    static final class BuilderImpl implements Builder {
        private String ephemerisId;

        private Instant epoch;

        private String name;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(EphemerisMetaData model) {
            ephemerisId(model.ephemerisId);
            epoch(model.epoch);
            name(model.name);
            source(model.source);
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        public final Instant getEpoch() {
            return epoch;
        }

        public final void setEpoch(Instant epoch) {
            this.epoch = epoch;
        }

        @Override
        public final Builder epoch(Instant epoch) {
            this.epoch = epoch;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(EphemerisSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public EphemerisMetaData build() {
            return new EphemerisMetaData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
