/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteEphemerisRequest extends GroundStationRequest implements
        ToCopyableBuilder<DeleteEphemerisRequest.Builder, DeleteEphemerisRequest> {
    private static final SdkField<String> EPHEMERIS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ephemerisId").getter(getter(DeleteEphemerisRequest::ephemerisId)).setter(setter(Builder::ephemerisId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ephemerisId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EPHEMERIS_ID_FIELD));

    private final String ephemerisId;

    private DeleteEphemerisRequest(BuilderImpl builder) {
        super(builder);
        this.ephemerisId = builder.ephemerisId;
    }

    /**
     * <p>
     * The AWS Ground Station ephemeris ID.
     * </p>
     * 
     * @return The AWS Ground Station ephemeris ID.
     */
    public final String ephemerisId() {
        return ephemerisId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ephemerisId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteEphemerisRequest)) {
            return false;
        }
        DeleteEphemerisRequest other = (DeleteEphemerisRequest) obj;
        return Objects.equals(ephemerisId(), other.ephemerisId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteEphemerisRequest").add("EphemerisId", ephemerisId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ephemerisId":
            return Optional.ofNullable(clazz.cast(ephemerisId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteEphemerisRequest, T> g) {
        return obj -> g.apply((DeleteEphemerisRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GroundStationRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteEphemerisRequest> {
        /**
         * <p>
         * The AWS Ground Station ephemeris ID.
         * </p>
         * 
         * @param ephemerisId
         *        The AWS Ground Station ephemeris ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ephemerisId(String ephemerisId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GroundStationRequest.BuilderImpl implements Builder {
        private String ephemerisId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteEphemerisRequest model) {
            super(model);
            ephemerisId(model.ephemerisId);
        }

        public final String getEphemerisId() {
            return ephemerisId;
        }

        public final void setEphemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
        }

        @Override
        public final Builder ephemerisId(String ephemerisId) {
            this.ephemerisId = ephemerisId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteEphemerisRequest build() {
            return new DeleteEphemerisRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
