/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregate status of Agent components.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregateStatus implements SdkPojo, Serializable, ToCopyableBuilder<AggregateStatus.Builder, AggregateStatus> {
    private static final SdkField<Map<String, Boolean>> SIGNATURE_MAP_FIELD = SdkField
            .<Map<String, Boolean>> builder(MarshallingType.MAP)
            .memberName("signatureMap")
            .getter(getter(AggregateStatus::signatureMap))
            .setter(setter(Builder::signatureMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AggregateStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_MAP_FIELD,
            STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, Boolean> signatureMap;

    private final String status;

    private AggregateStatus(BuilderImpl builder) {
        this.signatureMap = builder.signatureMap;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SignatureMap property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSignatureMap() {
        return signatureMap != null && !(signatureMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Sparse map of failure signatures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSignatureMap} method.
     * </p>
     * 
     * @return Sparse map of failure signatures.
     */
    public final Map<String, Boolean> signatureMap() {
        return signatureMap;
    }

    /**
     * <p>
     * Aggregate status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Aggregate status.
     * @see AgentStatus
     */
    public final AgentStatus status() {
        return AgentStatus.fromValue(status);
    }

    /**
     * <p>
     * Aggregate status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AgentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Aggregate status.
     * @see AgentStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSignatureMap() ? signatureMap() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateStatus)) {
            return false;
        }
        AggregateStatus other = (AggregateStatus) obj;
        return hasSignatureMap() == other.hasSignatureMap() && Objects.equals(signatureMap(), other.signatureMap())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AggregateStatus").add("SignatureMap", hasSignatureMap() ? signatureMap() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signatureMap":
            return Optional.ofNullable(clazz.cast(signatureMap()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregateStatus, T> g) {
        return obj -> g.apply((AggregateStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregateStatus> {
        /**
         * <p>
         * Sparse map of failure signatures.
         * </p>
         * 
         * @param signatureMap
         *        Sparse map of failure signatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureMap(Map<String, Boolean> signatureMap);

        /**
         * <p>
         * Aggregate status.
         * </p>
         * 
         * @param status
         *        Aggregate status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Aggregate status.
         * </p>
         * 
         * @param status
         *        Aggregate status.
         * @see AgentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AgentStatus
         */
        Builder status(AgentStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, Boolean> signatureMap = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregateStatus model) {
            signatureMap(model.signatureMap);
            status(model.status);
        }

        public final Map<String, Boolean> getSignatureMap() {
            if (signatureMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return signatureMap;
        }

        public final void setSignatureMap(Map<String, Boolean> signatureMap) {
            this.signatureMap = SignatureMapCopier.copy(signatureMap);
        }

        @Override
        public final Builder signatureMap(Map<String, Boolean> signatureMap) {
            this.signatureMap = SignatureMapCopier.copy(signatureMap);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public AggregateStatus build() {
            return new AggregateStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
